/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int xJ;
    private final String On;
    private final String Lk;
    private final Uri Mo;
    private final Uri Mp;
    private final int SY;
    private final String Nk;
    private final boolean SZ;
    private final PlayerEntity Ng;
    private final int Am;
    private final ParticipantResult Ta;
    private final String Mz;
    private final String MA;

    public ParticipantEntity(Participant participant) {
        this.xJ = 3;
        this.On = participant.getParticipantId();
        this.Lk = participant.getDisplayName();
        this.Mo = participant.getIconImageUri();
        this.Mp = participant.getHiResImageUri();
        this.SY = participant.getStatus();
        this.Nk = participant.gR();
        this.SZ = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.Ng = player == null ? null : new PlayerEntity(player);
        this.Am = participant.getCapabilities();
        this.Ta = participant.getResult();
        this.Mz = participant.getIconImageUrl();
        this.MA = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.xJ = versionCode;
        this.On = participantId;
        this.Lk = displayName;
        this.Mo = iconImageUri;
        this.Mp = hiResImageUri;
        this.SY = status;
        this.Nk = clientAddress;
        this.SZ = connectedToRoom;
        this.Ng = player;
        this.Am = capabilities;
        this.Ta = result;
        this.Mz = iconImageUrl;
        this.MA = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public int getStatus() {
        return this.SY;
    }

    @Override
    public String gR() {
        return this.Nk;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.SZ;
    }

    @Override
    public String getDisplayName() {
        if (this.Ng == null) {
            return this.Lk;
        }
        return this.Ng.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.Ng == null) {
            il.b(this.Lk, dataOut);
            return;
        }
        this.Ng.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.Ng == null) {
            return this.Mo;
        }
        return this.Ng.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.Ng == null) {
            return this.Mz;
        }
        return this.Ng.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.Ng == null) {
            return this.Mp;
        }
        return this.Ng.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.Ng == null) {
            return this.MA;
        }
        return this.Ng.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.On;
    }

    @Override
    public Player getPlayer() {
        return this.Ng;
    }

    @Override
    public ParticipantResult getResult() {
        return this.Ta;
    }

    @Override
    public int getCapabilities() {
        return this.Am;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return hl.hashCode(participant.getPlayer(), participant.getStatus(), participant.gR(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return hl.equal(participant2.getPlayer(), participant.getPlayer()) && hl.equal(participant2.getStatus(), participant.getStatus()) && hl.equal(participant2.gR(), participant.gR()) && hl.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && hl.equal(participant2.getDisplayName(), participant.getDisplayName()) && hl.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && hl.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && hl.equal(participant2.getCapabilities(), participant.getCapabilities()) && hl.equal(participant2.getResult(), participant.getResult()) && hl.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return hl.e(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.gR()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.On);
            dest.writeString(this.Lk);
            dest.writeString(this.Mo == null ? null : this.Mo.toString());
            dest.writeString(this.Mp == null ? null : this.Mp.toString());
            dest.writeInt(this.SY);
            dest.writeString(this.Nk);
            dest.writeInt(this.SZ ? 1 : 0);
            dest.writeInt(this.Ng == null ? 0 : 1);
            if (this.Ng != null) {
                this.Ng.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity bm(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.fl());
            if (bl2 || ParticipantEntity.aA(ParticipantEntity.class.getCanonicalName())) {
                return super.bm(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bm(x0);
        }
    }
}

