/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.hn;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener Th;
    private final RoomStatusUpdateListener Ti;
    private final RealTimeMessageReceivedListener Tj;
    private final String NN;
    private final int SV;
    private final String[] Tk;
    private final Bundle Tl;
    private final boolean Tm;

    private RoomConfig(Builder builder) {
        this.Th = builder.Th;
        this.Ti = builder.Ti;
        this.Tj = builder.Tj;
        this.NN = builder.Tn;
        this.SV = builder.SV;
        this.Tl = builder.Tl;
        this.Tm = builder.Tm;
        int n2 = builder.To.size();
        this.Tk = builder.To.toArray(new String[n2]);
        if (this.Tj == null) {
            hn.a(this.Tm, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.Th;
    }

    public String getInvitationId() {
        return this.NN;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.Ti;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.Tj;
    }

    public int getVariant() {
        return this.SV;
    }

    public String[] getInvitedPlayerIds() {
        return this.Tk;
    }

    public Bundle getAutoMatchCriteria() {
        return this.Tl;
    }

    public boolean isSocketEnabled() {
        return this.Tm;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener Th;
        RoomStatusUpdateListener Ti;
        RealTimeMessageReceivedListener Tj;
        String Tn = null;
        int SV = -1;
        ArrayList<String> To = new ArrayList();
        Bundle Tl;
        boolean Tm = false;

        private Builder(RoomUpdateListener updateListener) {
            this.Th = hn.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            hn.f(invitationId);
            this.Tn = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.Ti = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.Tj = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            hn.f(playerIds);
            this.To.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            hn.f(playerIds);
            this.To.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            hn.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.SV = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.Tm = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.Tl = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

