/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int xJ;
    private final GameEntity Rq;
    private final String Of;
    private final String Tp;
    private final long SR;
    private final String Tx;
    private final long Ty;
    private final String Tz;
    private final int TA;
    private final int SV;
    private final int TB;
    private final byte[] TC;
    private final ArrayList<ParticipantEntity> SU;
    private final String TD;
    private final byte[] TE;
    private final int TF;
    private final Bundle Tl;
    private final int TG;
    private final boolean TH;
    private final String Mm;
    private final String TI;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.xJ = 2;
        this.Rq = new GameEntity(match.getGame());
        this.Of = match.getMatchId();
        this.Tp = match.getCreatorId();
        this.SR = match.getCreationTimestamp();
        this.Tx = match.getLastUpdaterId();
        this.Ty = match.getLastUpdatedTimestamp();
        this.Tz = match.getPendingParticipantId();
        this.TA = match.getStatus();
        this.TG = match.getTurnStatus();
        this.SV = match.getVariant();
        this.TB = match.getVersion();
        this.TD = match.getRematchId();
        this.TF = match.getMatchNumber();
        this.Tl = match.getAutoMatchCriteria();
        this.TH = match.isLocallyModified();
        this.Mm = match.getDescription();
        this.TI = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.TC = null;
        } else {
            this.TC = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TC, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.TE = null;
        } else {
            this.TE = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.TE, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.SU = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.SU.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.xJ = versionCode;
        this.Rq = game;
        this.Of = matchId;
        this.Tp = creatorId;
        this.SR = creationTimestamp;
        this.Tx = lastUpdaterId;
        this.Ty = lastUpdatedTimestamp;
        this.Tz = pendingParticipantId;
        this.TA = matchStatus;
        this.TG = turnStatus;
        this.SV = variant;
        this.TB = version;
        this.TC = data;
        this.SU = participants;
        this.TD = rematchId;
        this.TE = previousData;
        this.TF = matchNumber;
        this.Tl = autoMatchCriteria;
        this.TH = isLocallyModified;
        this.Mm = description;
        this.TI = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public Game getGame() {
        return this.Rq;
    }

    @Override
    public String getMatchId() {
        return this.Of;
    }

    @Override
    public String getCreatorId() {
        return this.Tp;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SR;
    }

    @Override
    public String getLastUpdaterId() {
        return this.Tx;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Ty;
    }

    @Override
    public String getPendingParticipantId() {
        return this.Tz;
    }

    @Override
    public int getStatus() {
        return this.TA;
    }

    @Override
    public int getTurnStatus() {
        return this.TG;
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.TI;
    }

    @Override
    public Participant getDescriptionParticipant() {
        return this.getParticipant(this.getDescriptionParticipantId());
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        il.b(this.Mm, dataOut);
    }

    @Override
    public int getVariant() {
        return this.SV;
    }

    @Override
    public byte[] getData() {
        return this.TC;
    }

    @Override
    public int getVersion() {
        return this.TB;
    }

    @Override
    public String getRematchId() {
        return this.TD;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.TE;
    }

    @Override
    public int getMatchNumber() {
        return this.TF;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.Tl;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.Tl == null) {
            return 0;
        }
        return this.Tl.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.TA == 2 && this.TD == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.TH;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.SU);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return hl.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return hl.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && hl.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && hl.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && hl.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && hl.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && hl.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && hl.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && hl.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && hl.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && hl.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && hl.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && hl.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && hl.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && hl.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && hl.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && hl.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && hl.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && hl.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return hl.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

