/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntity;
import java.util.ArrayList;

public final class TurnBasedMatchRef
extends d
implements TurnBasedMatch {
    private final Game Sp;
    private final int RD;

    TurnBasedMatchRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.Sp = new GameRef(holder, dataRow);
        this.RD = numChildren;
    }

    @Override
    public Game getGame() {
        return this.Sp;
    }

    @Override
    public String getMatchId() {
        return this.getString("external_match_id");
    }

    @Override
    public String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public int getTurnStatus() {
        return this.getInteger("user_match_status");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.a("description", dataOut);
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.getString("description_participant_id");
    }

    @Override
    public Participant getDescriptionParticipant() {
        return this.getParticipant(this.getDescriptionParticipantId());
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.RD);
        for (int i2 = 0; i2 < this.RD; ++i2) {
            arrayList.add(new ParticipantRef(this.DD, this.Ez + i2));
        }
        return arrayList;
    }

    @Override
    public String getLastUpdaterId() {
        return this.getString("last_updater_external");
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public String getPendingParticipantId() {
        return this.getString("pending_participant_external");
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getVersion() {
        return this.getInteger("version");
    }

    @Override
    public String getRematchId() {
        return this.getString("rematch_id");
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.getByteArray("previous_match_data");
    }

    @Override
    public int getMatchNumber() {
        return this.getInteger("match_number");
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n2 = this.getInteger("automatch_min_players");
        int n3 = this.getInteger("automatch_max_players");
        long l2 = this.getLong("automatch_bit_mask");
        return TurnBasedMatchConfig.createAutoMatchCriteria(n2, n3, l2);
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    @Override
    public boolean canRematch() {
        return this.getTurnStatus() == 3 && this.getRematchId() == null && this.getParticipants().size() > 1;
    }

    @Override
    public boolean isLocallyModified() {
        return this.getBoolean("upsync_required");
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public TurnBasedMatch freeze() {
        return new TurnBasedMatchEntity(this);
    }

    @Override
    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        TurnBasedMatchEntity turnBasedMatchEntity = (TurnBasedMatchEntity)this.freeze();
        turnBasedMatchEntity.writeToParcel(dest, flags);
    }
}

