/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;
import com.google.android.gms.internal.hl;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int xJ;
    private final String Oq;
    private final long TJ;
    private final long TK;
    private final byte[] TL;
    private final int mState;
    private final String Nf;

    public MilestoneEntity(Milestone milestone) {
        this.xJ = 4;
        this.Oq = milestone.getMilestoneId();
        this.TJ = milestone.getCurrentProgress();
        this.TK = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Nf = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.TL = null;
        } else {
            this.TL = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TL, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.xJ = versionCode;
        this.Oq = milestoneId;
        this.TJ = currentProgress;
        this.TK = targetProgress;
        this.TL = completionBlob;
        this.mState = state;
        this.Nf = eventId;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getEventId() {
        return this.Nf;
    }

    @Override
    public String getMilestoneId() {
        return this.Oq;
    }

    @Override
    public long getCurrentProgress() {
        return this.TJ;
    }

    @Override
    public long getTargetProgress() {
        return this.TK;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.TL;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public Milestone freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.a(this);
    }

    static int a(Milestone milestone) {
        return hl.hashCode(milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId());
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.a(this, obj);
    }

    static boolean a(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return hl.equal(milestone2.getMilestoneId(), milestone.getMilestoneId()) && hl.equal(milestone2.getCurrentProgress(), milestone.getCurrentProgress()) && hl.equal(milestone2.getTargetProgress(), milestone.getTargetProgress()) && hl.equal(milestone2.getState(), milestone.getState()) && hl.equal(milestone2.getEventId(), milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.b(this);
    }

    static String b(Milestone milestone) {
        return hl.e(milestone).a("MilestoneId", milestone.getMilestoneId()).a("CurrentProgress", milestone.getCurrentProgress()).a("TargetProgress", milestone.getTargetProgress()).a("State", milestone.getState()).a("CompletionRewardData", milestone.getCompletionRewardData()).a("EventId", milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.a(this, out, flags);
    }
}

