/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int xJ;
    private final GameEntity Rq;
    private final String TM;
    private final long TN;
    private final Uri TO;
    private final String TP;
    private final String Mm;
    private final long TQ;
    private final long Ty;
    private final Uri TR;
    private final String TS;
    private final String mName;
    private final long TT;
    private final long TU;
    private final int mState;
    private final int AQ;
    private final ArrayList<MilestoneEntity> TV;

    public QuestEntity(Quest quest) {
        this.xJ = 2;
        this.Rq = new GameEntity(quest.getGame());
        this.TM = quest.getQuestId();
        this.TN = quest.getAcceptedTimestamp();
        this.Mm = quest.getDescription();
        this.TO = quest.getBannerImageUri();
        this.TP = quest.getBannerImageUrl();
        this.TQ = quest.getEndTimestamp();
        this.TR = quest.getIconImageUri();
        this.TS = quest.getIconImageUrl();
        this.Ty = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.TT = quest.iF();
        this.TU = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.AQ = quest.getType();
        List<Milestone> list = quest.iE();
        int n2 = list.size();
        this.TV = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.TV.add((MilestoneEntity)list.get(i2).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.xJ = versionCode;
        this.Rq = game;
        this.TM = questId;
        this.TN = acceptedTimestamp;
        this.TO = bannerImageUri;
        this.TP = bannerImageUrl;
        this.Mm = description;
        this.TQ = endTimestamp;
        this.Ty = lastUpdatedTimestamp;
        this.TR = iconImageUri;
        this.TS = iconImageUrl;
        this.mName = name;
        this.TT = notifyTimestamp;
        this.TU = startTimestamp;
        this.mState = state;
        this.AQ = type;
        this.TV = milestones;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getQuestId() {
        return this.TM;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        il.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        il.b(this.Mm, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.TR;
    }

    @Override
    public String getIconImageUrl() {
        return this.TS;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.TO;
    }

    @Override
    public String getBannerImageUrl() {
        return this.TP;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.iE().get(0);
    }

    @Override
    public List<Milestone> iE() {
        return new ArrayList<Milestone>(this.TV);
    }

    @Override
    public Game getGame() {
        return this.Rq;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.AQ;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.TN;
    }

    @Override
    public long getEndTimestamp() {
        return this.TQ;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Ty;
    }

    @Override
    public long iF() {
        return this.TT;
    }

    @Override
    public long getStartTimestamp() {
        return this.TU;
    }

    @Override
    public boolean isEndingSoon() {
        return this.TT <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return hl.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.iE(), quest.getName(), quest.iF(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return hl.equal(quest2.getGame(), quest.getGame()) && hl.equal(quest2.getQuestId(), quest.getQuestId()) && hl.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && hl.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && hl.equal(quest2.getDescription(), quest.getDescription()) && hl.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && hl.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && hl.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && hl.equal(quest2.iE(), quest.iE()) && hl.equal(quest2.getName(), quest.getName()) && hl.equal(quest2.iF(), quest.iF()) && hl.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && hl.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return hl.e(quest).a("Game", quest.getGame()).a("QuestId", quest.getQuestId()).a("AcceptedTimestamp", quest.getAcceptedTimestamp()).a("BannerImageUri", quest.getBannerImageUri()).a("BannerImageUrl", quest.getBannerImageUrl()).a("Description", quest.getDescription()).a("EndTimestamp", quest.getEndTimestamp()).a("IconImageUri", quest.getIconImageUri()).a("IconImageUrl", quest.getIconImageUrl()).a("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).a("Milestones", quest.iE()).a("Name", quest.getName()).a("NotifyTimestamp", quest.iF()).a("StartTimestamp", quest.getStartTimestamp()).a("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

