/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import com.google.android.gms.internal.hl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int xJ;
    private final GameEntity Rq;
    private final PlayerEntity TX;
    private final byte[] TC;
    private final String Oy;
    private final ArrayList<PlayerEntity> TY;
    private final int AQ;
    private final long SR;
    private final long TZ;
    private final Bundle Ua;
    private final int SY;

    public GameRequestEntity(GameRequest request) {
        this.xJ = 2;
        this.Rq = new GameEntity(request.getGame());
        this.TX = new PlayerEntity(request.getSender());
        this.Oy = request.getRequestId();
        this.AQ = request.getType();
        this.SR = request.getCreationTimestamp();
        this.TZ = request.getExpirationTimestamp();
        this.SY = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.TC = null;
        } else {
            this.TC = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TC, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n2 = list.size();
        this.TY = new ArrayList(n2);
        this.Ua = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)list.get(i2).freeze();
            String string2 = player.getPlayerId();
            this.TY.add((PlayerEntity)player);
            this.Ua.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.xJ = versionCode;
        this.Rq = game;
        this.TX = sender;
        this.TC = data;
        this.Oy = requestId;
        this.TY = recipients;
        this.AQ = type;
        this.SR = creationTimestamp;
        this.TZ = expirationTimestamp;
        this.Ua = recipientStatuses;
        this.SY = status;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getRequestId() {
        return this.Oy;
    }

    @Override
    public Game getGame() {
        return this.Rq;
    }

    @Override
    public Player getSender() {
        return this.TX;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.TY);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.TC;
    }

    @Override
    public int getType() {
        return this.AQ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SR;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.TZ;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.Ua.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.SY;
    }

    public Bundle iG() {
        return this.Ua;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return hl.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return hl.equal(gameRequest2.getGame(), gameRequest.getGame()) && hl.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && hl.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && hl.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && hl.equal(gameRequest2.getType(), gameRequest.getType()) && hl.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && hl.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(list.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return hl.e(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

