/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.a;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeCreator;
import com.google.android.gms.internal.hn;

public final class SnapshotMetadataChange
implements SafeParcelable {
    public static final SnapshotMetadataChangeCreator CREATOR = new SnapshotMetadataChangeCreator();
    private final int xJ;
    private final String Mm;
    private final Long Ud;
    private final Uri Ue;
    private a Uf;
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChange();

    SnapshotMetadataChange() {
        this(4, null, null, null, null);
    }

    SnapshotMetadataChange(String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this(4, description, playedTimeMillis, coverImage, coverImageUri);
    }

    SnapshotMetadataChange(int versionCode, String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this.xJ = versionCode;
        this.Mm = description;
        this.Ud = playedTimeMillis;
        this.Uf = coverImage;
        this.Ue = coverImageUri;
        if (this.Uf != null) {
            hn.a(this.Ue == null, "Cannot set both a URI and an image");
        } else if (this.Ue != null) {
            hn.a(this.Uf == null, "Cannot set both a URI and an image");
        }
    }

    public int getVersionCode() {
        return this.xJ;
    }

    public String getDescription() {
        return this.Mm;
    }

    public Long getPlayedTimeMillis() {
        return this.Ud;
    }

    public a iI() {
        return this.Uf;
    }

    public Bitmap getCoverImage() {
        return this.Uf == null ? null : this.Uf.eN();
    }

    public Uri getCoverImageUri() {
        return this.Ue;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataChangeCreator.a(this, out, flags);
    }

    public static final class Builder {
        private String Mm;
        private Long Ug;
        private a Uh;
        private Uri Ue;

        public Builder setDescription(String description) {
            this.Mm = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.Ug = playedTimeMillis;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.Uh = new a(coverImage);
            this.Ue = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.Mm = metadata.getDescription();
            this.Ug = metadata.getPlayedTime();
            if (this.Ug == -1L) {
                this.Ug = null;
            }
            this.Ue = metadata.getCoverImageUri();
            if (this.Ue != null) {
                this.Uh = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChange(this.Mm, this.Ug, this.Uh, this.Ue);
        }
    }
}

