/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.eu;
import java.util.Locale;

public final class ed {
    public final int qY;
    public final boolean qZ;
    public final boolean ra;
    public final String rb;
    public final String rc;
    public final boolean rd;
    public final boolean re;
    public final boolean rf;
    public final String rg;
    public final String rh;
    public final int ri;
    public final int rj;
    public final int rk;
    public final int rl;
    public final int rm;
    public final int rn;
    public final float ro;
    public final int rp;
    public final int rq;
    public final double rr;
    public final boolean rs;
    public final boolean rt;
    public final int ru;

    public ed(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.qY = audioManager.getMode();
        this.qZ = ed.a(packageManager, "geo:0,0?q=donuts") != null;
        this.ra = ed.a(packageManager, "http://www.google.com") != null;
        this.rb = telephonyManager.getNetworkOperator();
        this.rc = locale.getCountry();
        this.rd = eu.bQ();
        this.re = audioManager.isMusicActive();
        this.rf = audioManager.isSpeakerphoneOn();
        this.rg = locale.getLanguage();
        this.rh = ed.a(packageManager);
        this.ri = audioManager.getStreamVolume(3);
        this.rj = ed.a(context, connectivityManager, packageManager);
        this.rk = telephonyManager.getNetworkType();
        this.rl = telephonyManager.getPhoneType();
        this.rm = audioManager.getRingerMode();
        this.rn = audioManager.getStreamVolume(2);
        this.ro = displayMetrics.density;
        this.rp = displayMetrics.widthPixels;
        this.rq = displayMetrics.heightPixels;
        if (intent != null) {
            int n2 = intent.getIntExtra("status", -1);
            int n3 = intent.getIntExtra("level", -1);
            int n4 = intent.getIntExtra("scale", -1);
            this.rr = (float)n3 / (float)n4;
            this.rs = n2 == 2 || n2 == 5;
        } else {
            this.rr = -1.0;
            this.rs = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.rt = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.ru = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.rt = false;
            this.ru = -1;
        }
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = ed.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (ep.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

