/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hl;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int xJ;
    int mPriority;
    long Vi;
    long Vj;
    boolean Vk;
    long UY;
    int Vl;
    float Vm;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.xJ = 1;
        this.mPriority = 102;
        this.Vi = 3600000L;
        this.Vj = 600000L;
        this.Vk = false;
        this.UY = Long.MAX_VALUE;
        this.Vl = Integer.MAX_VALUE;
        this.Vm = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.cG(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.v(millis);
        this.Vi = millis;
        if (!this.Vk) {
            this.Vj = (long)((double)this.Vi / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.Vi;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.v(millis);
        this.Vk = true;
        this.Vj = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.Vj;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.UY = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.UY < 0L) {
            this.UY = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.UY = millis;
        if (this.UY < 0L) {
            this.UY = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.UY;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.Vl = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.Vl;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.Vm = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.Vm;
    }

    private static void v(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void cG(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.xJ = versionCode;
        this.mPriority = priority;
        this.Vi = interval;
        this.Vj = fastestInterval;
        this.Vk = explicitFastestInterval;
        this.UY = expireAt;
        this.Vl = numUpdates;
        this.Vm = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String cH(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.cH(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.Vi + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.Vj + "ms");
        if (this.UY != Long.MAX_VALUE) {
            long l2 = this.UY - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.Vl != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.Vl);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return hl.hashCode(this.mPriority, this.Vi, this.Vj, this.Vk, this.UY, this.Vl, Float.valueOf(this.Vm));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.Vi == locationRequest.Vi && this.Vj == locationRequest.Vj && this.Vk == locationRequest.Vk && this.UY == locationRequest.UY && this.Vl == locationRequest.Vl && this.Vm == locationRequest.Vm;
    }

    int getVersionCode() {
        return this.xJ;
    }
}

