/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.internal.hn;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.t;
import com.google.android.gms.maps.internal.u;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class MapFragment
extends Fragment {
    private final b Zz = new b(this);
    private GoogleMap ZA;

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions options) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    protected IMapFragmentDelegate jt() {
        this.Zz.ju();
        if (this.Zz.gC() == null) {
            return null;
        }
        return ((a)this.Zz.gC()).jt();
    }

    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.jt();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.ZA == null || this.ZA.jk().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.ZA = new GoogleMap(iGoogleMapDelegate);
        }
        return this.ZA;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.Zz.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.Zz.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.Zz.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.Zz.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.Zz.onCreateView(inflater, container, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.Zz.onResume();
    }

    public void onPause() {
        this.Zz.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.Zz.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.Zz.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.Zz.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.Zz.onSaveInstanceState(outState);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class b
    extends com.google.android.gms.dynamic.a<a> {
        private final Fragment Mg;
        protected f<a> ZC;
        private Activity oe;

        b(Fragment fragment) {
            this.Mg = fragment;
        }

        @Override
        protected void a(f<a> f2) {
            this.ZC = f2;
            this.ju();
        }

        public void ju() {
            if (this.oe != null && this.ZC != null && this.gC() == null) {
                try {
                    MapsInitializer.initialize((Context)this.oe);
                    IMapFragmentDelegate iMapFragmentDelegate = u.E((Context)this.oe).i(e.h(this.oe));
                    this.ZC.a(new a(this.Mg, iMapFragmentDelegate));
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.oe = activity;
            this.ju();
        }
    }

    static class a
    implements LifecycleDelegate {
        private final Fragment Mg;
        private final IMapFragmentDelegate ZB;

        public a(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.ZB = hn.f(iMapFragmentDelegate);
            this.Mg = hn.f(fragment);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.ZB.onInflate(e.h(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.Mg.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    t.a(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.ZB.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            d d2;
            try {
                d2 = this.ZB.onCreateView(e.h(inflater), e.h(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)e.e(d2);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.ZB.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.ZB.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            try {
                this.ZB.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onDestroy() {
            try {
                this.ZB.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.ZB.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.ZB.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate jt() {
            return this.ZB;
        }
    }
}

