/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.hn;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPositionCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.a;

public final class CameraPosition
implements SafeParcelable {
    public static final CameraPositionCreator CREATOR = new CameraPositionCreator();
    private final int xJ;
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    CameraPosition(int versionCode, LatLng target, float zoom, float tilt, float bearing) {
        hn.b(target, (Object)"null camera target");
        hn.b(0.0f <= tilt && tilt <= 90.0f, (Object)"Tilt needs to be between 0 and 90 inclusive");
        this.xJ = versionCode;
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt + 0.0f;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public CameraPosition(LatLng target, float zoom, float tilt, float bearing) {
        this(1, target, zoom, tilt, bearing);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jG()) {
            a.a(this, out, flags);
        } else {
            CameraPositionCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return hl.hashCode(this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing));
    }

    int getVersionCode() {
        return this.xJ;
    }

    public static final CameraPosition fromLatLngZoom(LatLng target, float zoom) {
        return new CameraPosition(target, zoom, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition camera) {
        return new Builder(camera);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o2;
        return this.target.equals(cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return hl.e(this).a("target", this.target).a("zoom", Float.valueOf(this.zoom)).a("tilt", Float.valueOf(this.tilt)).a("bearing", Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (typedArray.hasValue(2)) {
            f2 = typedArray.getFloat(2, 0.0f);
        }
        if (typedArray.hasValue(3)) {
            f3 = typedArray.getFloat(3, 0.0f);
        }
        LatLng latLng = new LatLng(f2, f3);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(5)) {
            builder.zoom(typedArray.getFloat(5, 0.0f));
        }
        if (typedArray.hasValue(1)) {
            builder.bearing(typedArray.getFloat(1, 0.0f));
        }
        if (typedArray.hasValue(4)) {
            builder.tilt(typedArray.getFloat(4, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng aak;
        private float aal;
        private float aam;
        private float aan;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            CameraPosition cameraPosition = previous;
            this.aak = cameraPosition.target;
            this.aal = cameraPosition.zoom;
            this.aam = cameraPosition.tilt;
            this.aan = cameraPosition.bearing;
        }

        public Builder target(LatLng location) {
            this.aak = location;
            return this;
        }

        public Builder zoom(float zoom) {
            this.aal = zoom;
            return this;
        }

        public Builder tilt(float tilt) {
            this.aam = tilt;
            return this;
        }

        public Builder bearing(float bearing) {
            this.aan = bearing;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.aak, this.aal, this.aam, this.aan);
        }
    }
}

