/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.internal.ll;
import com.google.android.gms.internal.lm;
import com.google.android.gms.internal.lt;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private b akq;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.b akr = com.google.android.gms.dynamic.b.a(this);
    private final c aks = new c();
    private a akt = new a(this);
    private final Fragment Mg = this;
    private WalletFragmentOptions akh;
    private WalletFragmentInitParams aki;
    private MaskedWalletRequest akj;
    private MaskedWallet akk;
    private Boolean akl;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.Mg.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.akq != null) {
            this.akq.initialize(initParams);
            this.aki = null;
        } else if (this.aki == null) {
            this.aki = initParams;
            if (this.akj != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.akk != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.akq != null) {
            this.akq.updateMaskedWalletRequest(request);
            this.akj = null;
        } else {
            this.akj = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.akq != null) {
            this.akq.updateMaskedWallet(maskedWallet);
            this.akk = null;
        } else {
            this.akk = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.akq != null) {
            this.akq.setEnabled(enabled);
            this.akl = null;
        } else {
            this.akl = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.akt.a(listener);
    }

    public int getState() {
        return this.akq != null ? this.akq.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.akh == null) {
            this.akh = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.akh);
        this.aks.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aki != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aki = walletFragmentInitParams;
            }
            if (this.akj == null) {
                this.akj = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.akk == null) {
                this.akk = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.akh = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.akl = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.Mg.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Mg.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.N((Context)this.Mg.getActivity());
            this.akh = walletFragmentOptions;
        }
        this.mCreated = true;
        this.aks.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.aks.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.aks.onStart();
    }

    public void onResume() {
        super.onResume();
        this.aks.onResume();
        FragmentManager fragmentManager = this.Mg.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Mg.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, this.Mg.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.aks.onPause();
    }

    public void onStop() {
        super.onStop();
        this.aks.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.aks.onSaveInstanceState(outState);
        if (this.aki != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.aki);
            this.aki = null;
        }
        if (this.akj != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.akj);
            this.akj = null;
        }
        if (this.akk != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.akk);
            this.akk = null;
        }
        if (this.akh != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.akh);
            this.akh = null;
        }
        if (this.akl != null) {
            outState.putBoolean("enabled", this.akl.booleanValue());
            this.akl = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.akq != null) {
            this.akq.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends lm.a {
        private OnStateChangedListener aku;
        private final WalletFragment akv;

        a(WalletFragment walletFragment) {
            this.akv = walletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.aku != null) {
                this.aku.onStateChanged(this.akv, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.aku = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final ll ako;

        private b(ll ll2) {
            this.ako = ll2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.ako.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.ako.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.ako.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.ako.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.ako.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.ako.a(e.h(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.ako.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.ako.onCreateView(e.h(inflater), e.h(container), savedInstanceState);
                return (View)e.e(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.ako.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.ako.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.ako.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.ako.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.ako.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.ako.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            Activity activity = WalletFragment.this.Mg.getActivity();
            if (WalletFragment.this.akq == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    ll ll2 = lt.a(activity, WalletFragment.this.akr, WalletFragment.this.akh, WalletFragment.this.akt);
                    WalletFragment.this.akq = new b(ll2);
                    WalletFragment.this.akh = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(WalletFragment.this.akq);
                if (WalletFragment.this.aki != null) {
                    WalletFragment.this.akq.initialize(WalletFragment.this.aki);
                    WalletFragment.this.aki = null;
                }
                if (WalletFragment.this.akj != null) {
                    WalletFragment.this.akq.updateMaskedWalletRequest(WalletFragment.this.akj);
                    WalletFragment.this.akj = null;
                }
                if (WalletFragment.this.akk != null) {
                    WalletFragment.this.akq.updateMaskedWallet(WalletFragment.this.akk);
                    WalletFragment.this.akk = null;
                }
                if (WalletFragment.this.akl != null) {
                    WalletFragment.this.akq.setEnabled(WalletFragment.this.akl);
                    WalletFragment.this.akl = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.Mg.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (WalletFragment.this.akh != null && (walletFragmentStyle = WalletFragment.this.akh.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.Mg.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.Mg.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, activity, -1);
        }
    }
}

