/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbbo;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdk;
import com.google.android.gms.internal.ads.zzbex;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbcn
extends zzbbo<Double>
implements zzbdk<Double>,
zzbex,
RandomAccess {
    private static final zzbcn zzdul = new zzbcn();
    private double[] zzdum;
    private int size;

    zzbcn() {
        this(new double[10], 0);
    }

    private zzbcn(double[] dArray, int n) {
        this.zzdum = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzacu();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzdum, n2, this.zzdum, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbcn)) {
            return super.equals(object);
        }
        zzbcn zzbcn2 = (zzbcn)object;
        if (this.size != zzbcn2.size) {
            return false;
        }
        double[] dArray = zzbcn2.zzdum;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzdum[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzdum[i]);
            n = n * 31 + zzbdf.zzw(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzacu();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzbs(n));
        }
        if (this.size < this.zzdum.length) {
            System.arraycopy(this.zzdum, n, this.zzdum, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzdum, 0, dArray, 0, n);
            System.arraycopy(this.zzdum, n, dArray, n + 1, this.size - n);
            this.zzdum = dArray;
        }
        this.zzdum[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzacu();
        zzbdf.checkNotNull(collection);
        if (!(collection instanceof zzbcn)) {
            return super.addAll(collection);
        }
        zzbcn zzbcn2 = (zzbcn)collection;
        if (zzbcn2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbcn2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbcn2.size;
        if (n > this.zzdum.length) {
            this.zzdum = Arrays.copyOf(this.zzdum, n);
        }
        System.arraycopy(zzbcn2.zzdum, 0, this.zzdum, this.size, zzbcn2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzacu();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzdum[i])) continue;
            System.arraycopy(this.zzdum, i + 1, this.zzdum, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzbr(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzbs(n));
        }
    }

    private final String zzbs(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbcn zzbcn2 = this;
        zzbcn2.zzacu();
        zzbcn2.zzbr(n);
        double d3 = zzbcn2.zzdum[n];
        zzbcn2.zzdum[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbcn zzbcn2 = this;
        zzbcn2.zzacu();
        zzbcn2.zzbr(n);
        double d = zzbcn2.zzdum[n];
        if (n < zzbcn2.size - 1) {
            System.arraycopy(zzbcn2.zzdum, n + 1, zzbcn2.zzdum, n, zzbcn2.size - n);
        }
        --zzbcn2.size;
        ++zzbcn2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzbdk zzbt(int n) {
        int n2 = n;
        zzbcn zzbcn2 = this;
        if (n2 < zzbcn2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbcn(Arrays.copyOf(zzbcn2.zzdum, n2), zzbcn2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbcn zzbcn2 = this;
        zzbcn2.zzbr(n);
        return zzbcn2.zzdum[n];
    }

    static {
        zzdul.zzact();
    }
}

