/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbck;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbgs;
import com.google.android.gms.internal.ads.zzbgz;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzbgr {
    private final ByteBuffer zzduf;
    private zzbck zzeeh;
    private int zzeei;

    private zzbgr(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzbgr(ByteBuffer byteBuffer) {
        this.zzduf = byteBuffer;
        this.zzduf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzbgr zzu(byte[] byArray) {
        return zzbgr.zzm(byArray, 0, byArray.length);
    }

    public static zzbgr zzm(byte[] byArray, int n, int n2) {
        return new zzbgr(byArray, 0, n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzl(n, 0);
        long l2 = l;
        this.zzy(l2);
    }

    public final void zzi(int n, long l) throws IOException {
        this.zzl(n, 0);
        long l2 = l;
        this.zzy(l2);
    }

    public final void zzm(int n, int n2) throws IOException {
        this.zzl(n, 0);
        int n3 = n2;
        zzbgr zzbgr2 = this;
        if (n3 >= 0) {
            zzbgr2.zzdm(n3);
            return;
        }
        zzbgr2.zzy(n3);
    }

    public final void zzf(int n, boolean bl) throws IOException {
        this.zzl(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzbgr zzbgr2 = this;
        if (!zzbgr2.zzduf.hasRemaining()) {
            throw new zzbgs(zzbgr2.zzduf.position(), zzbgr2.zzduf.limit());
        }
        zzbgr2.zzduf.put(by);
    }

    public final void zze(int n, String string) throws IOException {
        this.zzl(n, 2);
        String string2 = string;
        zzbgr zzbgr2 = this;
        try {
            int n2 = zzbgr.zzct(string2.length());
            int n3 = zzbgr.zzct(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzbgr2.zzduf.position();
                if (zzbgr2.zzduf.remaining() < n2) {
                    throw new zzbgs(n4 + n2, zzbgr2.zzduf.limit());
                }
                zzbgr2.zzduf.position(n4 + n2);
                zzbgr.zzd(string2, zzbgr2.zzduf);
                int n5 = zzbgr2.zzduf.position();
                zzbgr2.zzduf.position(n4);
                zzbgr2.zzdm(n5 - n4 - n2);
                zzbgr2.zzduf.position(n5);
                return;
            }
            zzbgr2.zzdm(zzbgr.zza(string2));
            zzbgr.zzd(string2, zzbgr2.zzduf);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzbgs zzbgs2 = new zzbgs(zzbgr2.zzduf.position(), zzbgr2.zzduf.limit());
            zzbgs2.initCause(bufferOverflowException);
            throw zzbgs2;
        }
    }

    public final void zza(int n, zzbgz zzbgz2) throws IOException {
        this.zzl(n, 2);
        zzbgz zzbgz3 = zzbgz2;
        zzbgr zzbgr2 = this;
        zzbgz zzbgz4 = zzbgz3;
        if (zzbgz4.zzees < 0) {
            zzbgz4.zzaet();
        }
        zzbgr2.zzdm(zzbgz4.zzees);
        zzbgz3.zza(zzbgr2);
    }

    public final void zze(int n, zzbel zzbel2) throws IOException {
        zzbgr zzbgr2 = this;
        if (zzbgr2.zzeeh == null) {
            zzbgr2.zzeeh = zzbck.zzb(zzbgr2.zzduf);
            zzbgr2.zzeei = zzbgr2.zzduf.position();
        } else if (zzbgr2.zzeei != zzbgr2.zzduf.position()) {
            zzbgr2.zzeeh.write(zzbgr2.zzduf.array(), zzbgr2.zzeei, zzbgr2.zzduf.position() - zzbgr2.zzeei);
            zzbgr2.zzeei = zzbgr2.zzduf.position();
        }
        zzbck zzbck2 = zzbgr2.zzeeh;
        zzbck2.zza(n, zzbel2);
        zzbck2.flush();
        this.zzeei = this.zzduf.position();
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzl(n, 2);
        byte[] byArray2 = byArray;
        zzbgr zzbgr2 = this;
        zzbgr2.zzdm(byArray2.length);
        zzbgr2.zzw(byArray2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zze(int n, long l) {
        return zzbgr.zzcl(n) + zzbgr.zzz(l);
    }

    public static int zzd(int n, long l) {
        return zzbgr.zzcl(n) + zzbgr.zzz(l);
    }

    public static int zzq(int n, int n2) {
        return zzbgr.zzcl(n) + zzbgr.zzcm(n2);
    }

    public static int zzf(int n, String string) {
        return zzbgr.zzcl(n) + zzbgr.zzet(string);
    }

    public static int zzb(int n, zzbgz zzbgz2) {
        int n2 = zzbgz2.zzaet();
        return zzbgr.zzcl(n) + (zzbgr.zzct(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzbgr.zzcl(n) + zzbgr.zzv(byArray);
    }

    public static int zzcm(int n) {
        if (n >= 0) {
            return zzbgr.zzct(n);
        }
        return 10;
    }

    public static int zzet(String string) {
        int n = zzbgr.zza(string);
        return zzbgr.zzct(n) + n;
    }

    public static int zzv(byte[] byArray) {
        return zzbgr.zzct(byArray.length) + byArray.length;
    }

    public final void zzaef() {
        if (this.zzduf.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzduf.remaining()));
        }
    }

    private final void zzdl(int n) throws IOException {
        byte by = (byte)n;
        zzbgr zzbgr2 = this;
        if (!zzbgr2.zzduf.hasRemaining()) {
            throw new zzbgs(zzbgr2.zzduf.position(), zzbgr2.zzduf.limit());
        }
        zzbgr2.zzduf.put(by);
    }

    public final void zzw(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzbgr zzbgr2 = this;
        if (zzbgr2.zzduf.remaining() >= n) {
            zzbgr2.zzduf.put(byArray2, 0, n);
            return;
        }
        throw new zzbgs(zzbgr2.zzduf.position(), zzbgr2.zzduf.limit());
    }

    public final void zzl(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzdm(n << 3 | n3);
    }

    public static int zzcl(int n) {
        return zzbgr.zzct(n << 3);
    }

    public final void zzdm(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzdl(n);
                return;
            }
            this.zzdl(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzct(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzy(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzdl((int)l);
                return;
            }
            this.zzdl((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzz(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

