/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbqk;
import com.google.android.gms.internal.ads.zzbsl;
import com.google.android.gms.internal.ads.zzbus;
import com.google.android.gms.internal.ads.zzbuz;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzbur {
    private final ByteBuffer zzaep;
    private zzbqk zzfwi;
    private int zzfwj;

    private zzbur(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzbur(ByteBuffer byteBuffer) {
        this.zzaep = byteBuffer;
        this.zzaep.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzbur zzx(byte[] byArray) {
        return zzbur.zzr(byArray, 0, byArray.length);
    }

    public static zzbur zzr(byte[] byArray, int n, int n2) {
        return new zzbur(byArray, 0, n2);
    }

    public final void zzj(int n, long l) throws IOException {
        this.zzu(n, 0);
        long l2 = l;
        this.zzbk(l2);
    }

    public final void zzr(int n, long l) throws IOException {
        this.zzu(n, 0);
        long l2 = l;
        this.zzbk(l2);
    }

    public final void zzv(int n, int n2) throws IOException {
        this.zzu(n, 0);
        int n3 = n2;
        zzbur zzbur2 = this;
        if (n3 >= 0) {
            zzbur2.zzge(n3);
            return;
        }
        zzbur2.zzbk(n3);
    }

    public final void zzj(int n, boolean bl) throws IOException {
        this.zzu(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzbur zzbur2 = this;
        if (!zzbur2.zzaep.hasRemaining()) {
            throw new zzbus(zzbur2.zzaep.position(), zzbur2.zzaep.limit());
        }
        zzbur2.zzaep.put(by);
    }

    public final void zzf(int n, String string) throws IOException {
        this.zzu(n, 2);
        String string2 = string;
        zzbur zzbur2 = this;
        try {
            int n2 = zzbur.zzfl(string2.length());
            int n3 = zzbur.zzfl(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzbur2.zzaep.position();
                if (zzbur2.zzaep.remaining() < n2) {
                    throw new zzbus(n4 + n2, zzbur2.zzaep.limit());
                }
                zzbur2.zzaep.position(n4 + n2);
                zzbur.zzd(string2, zzbur2.zzaep);
                int n5 = zzbur2.zzaep.position();
                zzbur2.zzaep.position(n4);
                zzbur2.zzge(n5 - n4 - n2);
                zzbur2.zzaep.position(n5);
                return;
            }
            zzbur2.zzge(zzbur.zza(string2));
            zzbur.zzd(string2, zzbur2.zzaep);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzbus zzbus2 = new zzbus(zzbur2.zzaep.position(), zzbur2.zzaep.limit());
            zzbus2.initCause(bufferOverflowException);
            throw zzbus2;
        }
    }

    public final void zza(int n, zzbuz zzbuz2) throws IOException {
        this.zzu(n, 2);
        zzbuz zzbuz3 = zzbuz2;
        zzbur zzbur2 = this;
        zzbuz zzbuz4 = zzbuz3;
        if (zzbuz4.zzfwt < 0) {
            zzbuz4.zzamj();
        }
        zzbur2.zzge(zzbuz4.zzfwt);
        zzbuz3.zza(zzbur2);
    }

    public final void zze(int n, zzbsl zzbsl2) throws IOException {
        zzbur zzbur2 = this;
        if (zzbur2.zzfwi == null) {
            zzbur2.zzfwi = zzbqk.zzn(zzbur2.zzaep);
            zzbur2.zzfwj = zzbur2.zzaep.position();
        } else if (zzbur2.zzfwj != zzbur2.zzaep.position()) {
            zzbur2.zzfwi.write(zzbur2.zzaep.array(), zzbur2.zzfwj, zzbur2.zzaep.position() - zzbur2.zzfwj);
            zzbur2.zzfwj = zzbur2.zzaep.position();
        }
        zzbqk zzbqk2 = zzbur2.zzfwi;
        zzbqk2.zza(n, zzbsl2);
        zzbqk2.flush();
        this.zzfwj = this.zzaep.position();
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzu(n, 2);
        byte[] byArray2 = byArray;
        zzbur zzbur2 = this;
        zzbur2.zzge(byArray2.length);
        zzbur2.zzz(byArray2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzn(int n, long l) {
        return zzbur.zzfd(n) + zzbur.zzbl(l);
    }

    public static int zzm(int n, long l) {
        return zzbur.zzfd(n) + zzbur.zzbl(l);
    }

    public static int zzz(int n, int n2) {
        return zzbur.zzfd(n) + zzbur.zzfe(n2);
    }

    public static int zzg(int n, String string) {
        return zzbur.zzfd(n) + zzbur.zzfy(string);
    }

    public static int zzb(int n, zzbuz zzbuz2) {
        int n2 = zzbuz2.zzamj();
        return zzbur.zzfd(n) + (zzbur.zzfl(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzbur.zzfd(n) + zzbur.zzy(byArray);
    }

    public static int zzfe(int n) {
        if (n >= 0) {
            return zzbur.zzfl(n);
        }
        return 10;
    }

    public static int zzfy(String string) {
        int n = zzbur.zza(string);
        return zzbur.zzfl(n) + n;
    }

    public static int zzy(byte[] byArray) {
        return zzbur.zzfl(byArray.length) + byArray.length;
    }

    public final void zzalv() {
        if (this.zzaep.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzaep.remaining()));
        }
    }

    private final void zzgd(int n) throws IOException {
        byte by = (byte)n;
        zzbur zzbur2 = this;
        if (!zzbur2.zzaep.hasRemaining()) {
            throw new zzbus(zzbur2.zzaep.position(), zzbur2.zzaep.limit());
        }
        zzbur2.zzaep.put(by);
    }

    public final void zzz(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzbur zzbur2 = this;
        if (zzbur2.zzaep.remaining() >= n) {
            zzbur2.zzaep.put(byArray2, 0, n);
            return;
        }
        throw new zzbus(zzbur2.zzaep.position(), zzbur2.zzaep.limit());
    }

    public final void zzu(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzge(n << 3 | n3);
    }

    public static int zzfd(int n) {
        return zzbur.zzfl(n << 3);
    }

    public final void zzge(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzgd(n);
                return;
            }
            this.zzgd(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzfl(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzbk(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzgd((int)l);
                return;
            }
            this.zzgd((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzbl(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

