/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzbrf;
import com.google.android.gms.internal.ads.zzbrk;
import com.google.android.gms.internal.ads.zzbsx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbps
extends zzbpo<Boolean>
implements zzbrk<Boolean>,
zzbsx,
RandomAccess {
    private static final zzbps zzflg = new zzbps();
    private boolean[] zzflh;
    private int size;

    zzbps() {
        this(new boolean[10], 0);
    }

    private zzbps(boolean[] blArray, int n) {
        this.zzflh = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzakk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzflh, n2, this.zzflh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbps)) {
            return super.equals(object);
        }
        zzbps zzbps2 = (zzbps)object;
        if (this.size != zzbps2.size) {
            return false;
        }
        boolean[] blArray = zzbps2.zzflh;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzflh[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzbrf.zzbf(this.zzflh[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzi(this.size, bl);
    }

    private final void zzi(int n, boolean bl) {
        this.zzakk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
        if (this.size < this.zzflh.length) {
            System.arraycopy(this.zzflh, n, this.zzflh, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzflh, 0, blArray, 0, n);
            System.arraycopy(this.zzflh, n, blArray, n + 1, this.size - n);
            this.zzflh = blArray;
        }
        this.zzflh[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzakk();
        zzbrf.checkNotNull(collection);
        if (!(collection instanceof zzbps)) {
            return super.addAll(collection);
        }
        zzbps zzbps2 = (zzbps)collection;
        if (zzbps2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbps2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbps2.size;
        if (n > this.zzflh.length) {
            this.zzflh = Arrays.copyOf(this.zzflh, n);
        }
        System.arraycopy(zzbps2.zzflh, 0, this.zzflh, this.size, zzbps2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzakk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzflh[i])) continue;
            System.arraycopy(this.zzflh, i + 1, this.zzflh, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzej(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
    }

    private final String zzek(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzbps zzbps2 = this;
        zzbps2.zzakk();
        zzbps2.zzej(n);
        boolean bl3 = zzbps2.zzflh[n];
        zzbps2.zzflh[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbps zzbps2 = this;
        zzbps2.zzakk();
        zzbps2.zzej(n);
        boolean bl = zzbps2.zzflh[n];
        if (n < zzbps2.size - 1) {
            System.arraycopy(zzbps2.zzflh, n + 1, zzbps2.zzflh, n, zzbps2.size - n);
        }
        --zzbps2.size;
        ++zzbps2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zzi(n, bl);
    }

    @Override
    public final /* synthetic */ zzbrk zzel(int n) {
        int n2 = n;
        zzbps zzbps2 = this;
        if (n2 < zzbps2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbps(Arrays.copyOf(zzbps2.zzflh, n2), zzbps2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbps zzbps2 = this;
        zzbps2.zzej(n);
        return zzbps2.zzflh[n];
    }

    static {
        zzflg.zzakj();
    }
}

