/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzbrf;
import com.google.android.gms.internal.ads.zzbrk;
import com.google.android.gms.internal.ads.zzbsx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbra
extends zzbpo<Float>
implements zzbrk<Float>,
zzbsx,
RandomAccess {
    private static final zzbra zzfpq = new zzbra();
    private float[] zzfpr;
    private int size;

    zzbra() {
        this(new float[10], 0);
    }

    private zzbra(float[] fArray, int n) {
        this.zzfpr = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzakk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfpr, n2, this.zzfpr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbra)) {
            return super.equals(object);
        }
        zzbra zzbra2 = (zzbra)object;
        if (this.size != zzbra2.size) {
            return false;
        }
        float[] fArray = zzbra2.zzfpr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfpr[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzfpr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzh(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzakk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
        if (this.size < this.zzfpr.length) {
            System.arraycopy(this.zzfpr, n, this.zzfpr, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzfpr, 0, fArray, 0, n);
            System.arraycopy(this.zzfpr, n, fArray, n + 1, this.size - n);
            this.zzfpr = fArray;
        }
        this.zzfpr[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzakk();
        zzbrf.checkNotNull(collection);
        if (!(collection instanceof zzbra)) {
            return super.addAll(collection);
        }
        zzbra zzbra2 = (zzbra)collection;
        if (zzbra2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbra2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbra2.size;
        if (n > this.zzfpr.length) {
            this.zzfpr = Arrays.copyOf(this.zzfpr, n);
        }
        System.arraycopy(zzbra2.zzfpr, 0, this.zzfpr, this.size, zzbra2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzakk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzfpr[i]))) continue;
            System.arraycopy(this.zzfpr, i + 1, this.zzfpr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzej(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
    }

    private final String zzek(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzbra zzbra2 = this;
        zzbra2.zzakk();
        zzbra2.zzej(n);
        float f3 = zzbra2.zzfpr[n];
        zzbra2.zzfpr[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbra zzbra2 = this;
        zzbra2.zzakk();
        zzbra2.zzej(n);
        float f = zzbra2.zzfpr[n];
        if (n < zzbra2.size - 1) {
            System.arraycopy(zzbra2.zzfpr, n + 1, zzbra2.zzfpr, n, zzbra2.size - n);
        }
        --zzbra2.size;
        ++zzbra2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzbrk zzel(int n) {
        int n2 = n;
        zzbra zzbra2 = this;
        if (n2 < zzbra2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbra(Arrays.copyOf(zzbra2.zzfpr, n2), zzbra2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbra zzbra2 = this;
        zzbra2.zzej(n);
        return Float.valueOf(zzbra2.zzfpr[n]);
    }

    static {
        zzfpq.zzakj();
    }
}

