/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbpo;
import com.google.android.gms.internal.ads.zzbrf;
import com.google.android.gms.internal.ads.zzbrk;
import com.google.android.gms.internal.ads.zzbsx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbrz
extends zzbpo<Long>
implements zzbrk<Long>,
zzbsx,
RandomAccess {
    private static final zzbrz zzfru = new zzbrz();
    private long[] zzfrv;
    private int size;

    zzbrz() {
        this(new long[10], 0);
    }

    private zzbrz(long[] lArray, int n) {
        this.zzfrv = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzakk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfrv, n2, this.zzfrv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbrz)) {
            return super.equals(object);
        }
        zzbrz zzbrz2 = (zzbrz)object;
        if (this.size != zzbrz2.size) {
            return false;
        }
        long[] lArray = zzbrz2.zzfrv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfrv[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzbrf.zzbi(this.zzfrv[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzej(n);
        return this.zzfrv[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbj(long l) {
        this.zzt(this.size, l);
    }

    private final void zzt(int n, long l) {
        this.zzakk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
        if (this.size < this.zzfrv.length) {
            System.arraycopy(this.zzfrv, n, this.zzfrv, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzfrv, 0, lArray, 0, n);
            System.arraycopy(this.zzfrv, n, lArray, n + 1, this.size - n);
            this.zzfrv = lArray;
        }
        this.zzfrv[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzakk();
        zzbrf.checkNotNull(collection);
        if (!(collection instanceof zzbrz)) {
            return super.addAll(collection);
        }
        zzbrz zzbrz2 = (zzbrz)collection;
        if (zzbrz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbrz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbrz2.size;
        if (n > this.zzfrv.length) {
            this.zzfrv = Arrays.copyOf(this.zzfrv, n);
        }
        System.arraycopy(zzbrz2.zzfrv, 0, this.zzfrv, this.size, zzbrz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzakk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzfrv[i])) continue;
            System.arraycopy(this.zzfrv, i + 1, this.zzfrv, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzej(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzek(n));
        }
    }

    private final String zzek(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzbrz zzbrz2 = this;
        zzbrz2.zzakk();
        zzbrz2.zzej(n);
        long l3 = zzbrz2.zzfrv[n];
        zzbrz2.zzfrv[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbrz zzbrz2 = this;
        zzbrz2.zzakk();
        zzbrz2.zzej(n);
        long l = zzbrz2.zzfrv[n];
        if (n < zzbrz2.size - 1) {
            System.arraycopy(zzbrz2.zzfrv, n + 1, zzbrz2.zzfrv, n, zzbrz2.size - n);
        }
        --zzbrz2.size;
        ++zzbrz2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzt(n, l);
    }

    @Override
    public final /* synthetic */ zzbrk zzel(int n) {
        int n2 = n;
        zzbrz zzbrz2 = this;
        if (n2 < zzbrz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbrz(Arrays.copyOf(zzbrz2.zzfrv, n2), zzbrz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzfru.zzakj();
    }
}

