/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdml;
import com.google.android.gms.internal.ads.zzdod;
import com.google.android.gms.internal.ads.zzdoj;
import com.google.android.gms.internal.ads.zzdpw;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdnl
extends zzdml<Double>
implements zzdoj<Double>,
zzdpw,
RandomAccess {
    private static final zzdnl zzhdw = new zzdnl(new double[0], 0);
    private double[] zzhdx;
    private int size;

    zzdnl() {
        this(new double[10], 0);
    }

    private zzdnl(double[] dArray, int n) {
        this.zzhdx = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzavk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhdx, n2, this.zzhdx, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdnl)) {
            return super.equals(object);
        }
        zzdnl zzdnl2 = (zzdnl)object;
        if (this.size != zzdnl2.size) {
            return false;
        }
        double[] dArray = zzdnl2.zzhdx;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhdx[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhdx[i]);
            n = n * 31 + zzdod.zzft(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzavk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
        if (this.size < this.zzhdx.length) {
            System.arraycopy(this.zzhdx, n, this.zzhdx, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhdx, 0, dArray, 0, n);
            System.arraycopy(this.zzhdx, n, dArray, n + 1, this.size - n);
            this.zzhdx = dArray;
        }
        this.zzhdx[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzavk();
        zzdod.checkNotNull(collection);
        if (!(collection instanceof zzdnl)) {
            return super.addAll(collection);
        }
        zzdnl zzdnl2 = (zzdnl)collection;
        if (zzdnl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdnl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdnl2.size;
        if (n > this.zzhdx.length) {
            this.zzhdx = Arrays.copyOf(this.zzhdx, n);
        }
        System.arraycopy(zzdnl2.zzhdx, 0, this.zzhdx, this.size, zzdnl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzavk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhdx[i])) continue;
            System.arraycopy(this.zzhdx, i + 1, this.zzhdx, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdnl zzdnl2 = this;
        zzdnl2.zzavk();
        zzdnl2.zzfj(n);
        double d3 = zzdnl2.zzhdx[n];
        zzdnl2.zzhdx[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdnl zzdnl2 = this;
        zzdnl2.zzavk();
        zzdnl2.zzfj(n);
        double d = zzdnl2.zzhdx[n];
        if (n < zzdnl2.size - 1) {
            System.arraycopy(zzdnl2.zzhdx, n + 1, zzdnl2.zzhdx, n, zzdnl2.size - n - 1);
        }
        --zzdnl2.size;
        ++zzdnl2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzdoj zzfl(int n) {
        int n2 = n;
        zzdnl zzdnl2 = this;
        if (n2 < zzdnl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdnl(Arrays.copyOf(zzdnl2.zzhdx, n2), zzdnl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdnl zzdnl2 = this;
        zzdnl2.zzfj(n);
        return zzdnl2.zzhdx[n];
    }

    static {
        zzhdw.zzavj();
    }
}

