/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdml;
import com.google.android.gms.internal.ads.zzdod;
import com.google.android.gms.internal.ads.zzdoh;
import com.google.android.gms.internal.ads.zzdoj;
import com.google.android.gms.internal.ads.zzdpw;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdoc
extends zzdml<Integer>
implements zzdoh,
zzdpw,
RandomAccess {
    private static final zzdoc zzhhy = new zzdoc(new int[0], 0);
    private int[] zzhhz;
    private int size;

    public static zzdoc zzayc() {
        return zzhhy;
    }

    zzdoc() {
        this(new int[10], 0);
    }

    private zzdoc(int[] nArray, int n) {
        this.zzhhz = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzavk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhhz, n2, this.zzhhz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdoc)) {
            return super.equals(object);
        }
        zzdoc zzdoc2 = (zzdoc)object;
        if (this.size != zzdoc2.size) {
            return false;
        }
        int[] nArray = zzdoc2.zzhhz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhhz[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzhhz[i];
        }
        return n;
    }

    @Override
    public final zzdoh zzgo(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzdoc(Arrays.copyOf(this.zzhhz, n), this.size);
    }

    public final int getInt(int n) {
        this.zzfj(n);
        return this.zzhhz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzgp(int n) {
        this.zzaj(this.size, n);
    }

    private final void zzaj(int n, int n2) {
        this.zzavk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
        if (this.size < this.zzhhz.length) {
            System.arraycopy(this.zzhhz, n, this.zzhhz, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhhz, 0, nArray, 0, n);
            System.arraycopy(this.zzhhz, n, nArray, n + 1, this.size - n);
            this.zzhhz = nArray;
        }
        this.zzhhz[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzavk();
        zzdod.checkNotNull(collection);
        if (!(collection instanceof zzdoc)) {
            return super.addAll(collection);
        }
        zzdoc zzdoc2 = (zzdoc)collection;
        if (zzdoc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdoc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdoc2.size;
        if (n > this.zzhhz.length) {
            this.zzhhz = Arrays.copyOf(this.zzhhz, n);
        }
        System.arraycopy(zzdoc2.zzhhz, 0, this.zzhhz, this.size, zzdoc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzavk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhhz[i])) continue;
            System.arraycopy(this.zzhhz, i + 1, this.zzhhz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdoc zzdoc2 = this;
        zzdoc2.zzavk();
        zzdoc2.zzfj(n);
        int n4 = zzdoc2.zzhhz[n];
        zzdoc2.zzhhz[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdoc zzdoc2 = this;
        zzdoc2.zzavk();
        zzdoc2.zzfj(n);
        int n2 = zzdoc2.zzhhz[n];
        if (n < zzdoc2.size - 1) {
            System.arraycopy(zzdoc2.zzhhz, n + 1, zzdoc2.zzhhz, n, zzdoc2.size - n - 1);
        }
        --zzdoc2.size;
        ++zzdoc2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzaj(n, n2);
    }

    @Override
    public final /* synthetic */ zzdoj zzfl(int n) {
        return this.zzgo(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzhhy.zzavj();
    }
}

