/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdrx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdpx
extends zzdol<Float>
implements zzdqi<Float>,
zzdrx,
RandomAccess {
    private static final zzdpx zzhjq = new zzdpx(new float[0], 0);
    private float[] zzhjr;
    private int size;

    zzdpx() {
        this(new float[10], 0);
    }

    private zzdpx(float[] fArray, int n) {
        this.zzhjr = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhjr, n2, this.zzhjr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdpx)) {
            return super.equals(object);
        }
        zzdpx zzdpx2 = (zzdpx)object;
        if (this.size != zzdpx2.size) {
            return false;
        }
        float[] fArray = zzdpx2.zzhjr;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzhjr[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzhjr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzh(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhjr.length) {
            System.arraycopy(this.zzhjr, n, this.zzhjr, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhjr, 0, fArray, 0, n);
            System.arraycopy(this.zzhjr, n, fArray, n + 1, this.size - n);
            this.zzhjr = fArray;
        }
        this.zzhjr[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzaxf();
        zzdqc.checkNotNull(collection);
        if (!(collection instanceof zzdpx)) {
            return super.addAll(collection);
        }
        zzdpx zzdpx2 = (zzdpx)collection;
        if (zzdpx2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdpx2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdpx2.size;
        if (n > this.zzhjr.length) {
            this.zzhjr = Arrays.copyOf(this.zzhjr, n);
        }
        System.arraycopy(zzdpx2.zzhjr, 0, this.zzhjr, this.size, zzdpx2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzhjr[i]))) continue;
            System.arraycopy(this.zzhjr, i + 1, this.zzhjr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzdpx zzdpx2 = this;
        zzdpx2.zzaxf();
        zzdpx2.zzfk(n);
        float f3 = zzdpx2.zzhjr[n];
        zzdpx2.zzhjr[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdpx zzdpx2 = this;
        zzdpx2.zzaxf();
        zzdpx2.zzfk(n);
        float f = zzdpx2.zzhjr[n];
        if (n < zzdpx2.size - 1) {
            System.arraycopy(zzdpx2.zzhjr, n + 1, zzdpx2.zzhjr, n, zzdpx2.size - n - 1);
        }
        --zzdpx2.size;
        ++zzdpx2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzdqi zzfm(int n) {
        int n2 = n;
        zzdpx zzdpx2 = this;
        if (n2 < zzdpx2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdpx(Arrays.copyOf(zzdpx2.zzhjr, n2), zzdpx2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdpx zzdpx2 = this;
        zzdpx2.zzfk(n);
        return Float.valueOf(zzdpx2.zzhjr[n]);
    }

    static {
        zzhjq.zzaxe();
    }
}

