/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqg;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdrx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdqd
extends zzdol<Integer>
implements zzdqg,
zzdrx,
RandomAccess {
    private static final zzdqd zzhky = new zzdqd(new int[0], 0);
    private int[] zzhkz;
    private int size;

    public static zzdqd zzazw() {
        return zzhky;
    }

    zzdqd() {
        this(new int[10], 0);
    }

    private zzdqd(int[] nArray, int n) {
        this.zzhkz = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhkz, n2, this.zzhkz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdqd)) {
            return super.equals(object);
        }
        zzdqd zzdqd2 = (zzdqd)object;
        if (this.size != zzdqd2.size) {
            return false;
        }
        int[] nArray = zzdqd2.zzhkz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhkz[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzhkz[i];
        }
        return n;
    }

    @Override
    public final zzdqg zzgp(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzdqd(Arrays.copyOf(this.zzhkz, n), this.size);
    }

    public final int getInt(int n) {
        this.zzfk(n);
        return this.zzhkz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzgq(int n) {
        this.zzam(this.size, n);
    }

    private final void zzam(int n, int n2) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhkz.length) {
            System.arraycopy(this.zzhkz, n, this.zzhkz, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhkz, 0, nArray, 0, n);
            System.arraycopy(this.zzhkz, n, nArray, n + 1, this.size - n);
            this.zzhkz = nArray;
        }
        this.zzhkz[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzaxf();
        zzdqc.checkNotNull(collection);
        if (!(collection instanceof zzdqd)) {
            return super.addAll(collection);
        }
        zzdqd zzdqd2 = (zzdqd)collection;
        if (zzdqd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdqd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdqd2.size;
        if (n > this.zzhkz.length) {
            this.zzhkz = Arrays.copyOf(this.zzhkz, n);
        }
        System.arraycopy(zzdqd2.zzhkz, 0, this.zzhkz, this.size, zzdqd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhkz[i])) continue;
            System.arraycopy(this.zzhkz, i + 1, this.zzhkz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdqd zzdqd2 = this;
        zzdqd2.zzaxf();
        zzdqd2.zzfk(n);
        int n4 = zzdqd2.zzhkz[n];
        zzdqd2.zzhkz[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdqd zzdqd2 = this;
        zzdqd2.zzaxf();
        zzdqd2.zzfk(n);
        int n2 = zzdqd2.zzhkz[n];
        if (n < zzdqd2.size - 1) {
            System.arraycopy(zzdqd2.zzhkz, n + 1, zzdqd2.zzhkz, n, zzdqd2.size - n - 1);
        }
        --zzdqd2.size;
        ++zzdqd2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzam(n, n2);
    }

    @Override
    public final /* synthetic */ zzdqi zzfm(int n) {
        return this.zzgp(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzhky.zzaxe();
    }
}

