/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdrx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdqz
extends zzdol<Long>
implements zzdqi<Long>,
zzdrx,
RandomAccess {
    private static final zzdqz zzhmc = new zzdqz(new long[0], 0);
    private long[] zzhmd;
    private int size;

    zzdqz() {
        this(new long[10], 0);
    }

    private zzdqz(long[] lArray, int n) {
        this.zzhmd = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhmd, n2, this.zzhmd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdqz)) {
            return super.equals(object);
        }
        zzdqz zzdqz2 = (zzdqz)object;
        if (this.size != zzdqz2.size) {
            return false;
        }
        long[] lArray = zzdqz2.zzhmd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhmd[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdqc.zzfk(this.zzhmd[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzfk(n);
        return this.zzhmd[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzfl(long l) {
        this.zzq(this.size, l);
    }

    private final void zzq(int n, long l) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhmd.length) {
            System.arraycopy(this.zzhmd, n, this.zzhmd, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhmd, 0, lArray, 0, n);
            System.arraycopy(this.zzhmd, n, lArray, n + 1, this.size - n);
            this.zzhmd = lArray;
        }
        this.zzhmd[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzaxf();
        zzdqc.checkNotNull(collection);
        if (!(collection instanceof zzdqz)) {
            return super.addAll(collection);
        }
        zzdqz zzdqz2 = (zzdqz)collection;
        if (zzdqz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdqz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdqz2.size;
        if (n > this.zzhmd.length) {
            this.zzhmd = Arrays.copyOf(this.zzhmd, n);
        }
        System.arraycopy(zzdqz2.zzhmd, 0, this.zzhmd, this.size, zzdqz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhmd[i])) continue;
            System.arraycopy(this.zzhmd, i + 1, this.zzhmd, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdqz zzdqz2 = this;
        zzdqz2.zzaxf();
        zzdqz2.zzfk(n);
        long l3 = zzdqz2.zzhmd[n];
        zzdqz2.zzhmd[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdqz zzdqz2 = this;
        zzdqz2.zzaxf();
        zzdqz2.zzfk(n);
        long l = zzdqz2.zzhmd[n];
        if (n < zzdqz2.size - 1) {
            System.arraycopy(zzdqz2.zzhmd, n + 1, zzdqz2.zzhmd, n, zzdqz2.size - n - 1);
        }
        --zzdqz2.size;
        ++zzdqz2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzq(n, l);
    }

    @Override
    public final /* synthetic */ zzdqi zzfm(int n) {
        int n2 = n;
        zzdqz zzdqz2 = this;
        if (n2 < zzdqz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdqz(Arrays.copyOf(zzdqz2.zzhmd, n2), zzdqz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzhmc.zzaxe();
    }
}

