/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdrx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdop
extends zzdol<Boolean>
implements zzdqi<Boolean>,
zzdrx,
RandomAccess {
    private static final zzdop zzhfh = new zzdop(new boolean[0], 0);
    private boolean[] zzhfi;
    private int size;

    zzdop() {
        this(new boolean[10], 0);
    }

    private zzdop(boolean[] blArray, int n) {
        this.zzhfi = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhfi, n2, this.zzhfi, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdop)) {
            return super.equals(object);
        }
        zzdop zzdop2 = (zzdop)object;
        if (this.size != zzdop2.size) {
            return false;
        }
        boolean[] blArray = zzdop2.zzhfi;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhfi[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdqc.zzbj(this.zzhfi[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzg(this.size, bl);
    }

    private final void zzg(int n, boolean bl) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhfi.length) {
            System.arraycopy(this.zzhfi, n, this.zzhfi, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhfi, 0, blArray, 0, n);
            System.arraycopy(this.zzhfi, n, blArray, n + 1, this.size - n);
            this.zzhfi = blArray;
        }
        this.zzhfi[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzaxf();
        zzdqc.checkNotNull(collection);
        if (!(collection instanceof zzdop)) {
            return super.addAll(collection);
        }
        zzdop zzdop2 = (zzdop)collection;
        if (zzdop2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdop2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdop2.size;
        if (n > this.zzhfi.length) {
            this.zzhfi = Arrays.copyOf(this.zzhfi, n);
        }
        System.arraycopy(zzdop2.zzhfi, 0, this.zzhfi, this.size, zzdop2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhfi[i])) continue;
            System.arraycopy(this.zzhfi, i + 1, this.zzhfi, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzdop zzdop2 = this;
        zzdop2.zzaxf();
        zzdop2.zzfk(n);
        boolean bl3 = zzdop2.zzhfi[n];
        zzdop2.zzhfi[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdop zzdop2 = this;
        zzdop2.zzaxf();
        zzdop2.zzfk(n);
        boolean bl = zzdop2.zzhfi[n];
        if (n < zzdop2.size - 1) {
            System.arraycopy(zzdop2.zzhfi, n + 1, zzdop2.zzhfi, n, zzdop2.size - n - 1);
        }
        --zzdop2.size;
        ++zzdop2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zzg(n, bl);
    }

    @Override
    public final /* synthetic */ zzdqi zzfm(int n) {
        int n2 = n;
        zzdop zzdop2 = this;
        if (n2 < zzdop2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdop(Arrays.copyOf(zzdop2.zzhfi, n2), zzdop2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdop zzdop2 = this;
        zzdop2.zzfk(n);
        return zzdop2.zzhfi[n];
    }

    static {
        zzhfh.zzaxe();
    }
}

