/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdon;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdqk;
import com.google.android.gms.internal.ads.zzdrz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdqf
extends zzdon<Integer>
implements zzdqi,
zzdrz,
RandomAccess {
    private static final zzdqf zzhky = new zzdqf(new int[0], 0);
    private int[] zzhkz;
    private int size;

    public static zzdqf zzazw() {
        return zzhky;
    }

    zzdqf() {
        this(new int[10], 0);
    }

    private zzdqf(int[] nArray, int n) {
        this.zzhkz = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhkz, n2, this.zzhkz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdqf)) {
            return super.equals(object);
        }
        zzdqf zzdqf2 = (zzdqf)object;
        if (this.size != zzdqf2.size) {
            return false;
        }
        int[] nArray = zzdqf2.zzhkz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhkz[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzhkz[i];
        }
        return n;
    }

    @Override
    public final zzdqi zzgp(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzdqf(Arrays.copyOf(this.zzhkz, n), this.size);
    }

    public final int getInt(int n) {
        this.zzfk(n);
        return this.zzhkz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzgq(int n) {
        this.zzam(this.size, n);
    }

    private final void zzam(int n, int n2) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhkz.length) {
            System.arraycopy(this.zzhkz, n, this.zzhkz, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhkz, 0, nArray, 0, n);
            System.arraycopy(this.zzhkz, n, nArray, n + 1, this.size - n);
            this.zzhkz = nArray;
        }
        this.zzhkz[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzaxf();
        zzdqe.checkNotNull(collection);
        if (!(collection instanceof zzdqf)) {
            return super.addAll(collection);
        }
        zzdqf zzdqf2 = (zzdqf)collection;
        if (zzdqf2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdqf2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdqf2.size;
        if (n > this.zzhkz.length) {
            this.zzhkz = Arrays.copyOf(this.zzhkz, n);
        }
        System.arraycopy(zzdqf2.zzhkz, 0, this.zzhkz, this.size, zzdqf2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhkz[i])) continue;
            System.arraycopy(this.zzhkz, i + 1, this.zzhkz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdqf zzdqf2 = this;
        zzdqf2.zzaxf();
        zzdqf2.zzfk(n);
        int n4 = zzdqf2.zzhkz[n];
        zzdqf2.zzhkz[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdqf zzdqf2 = this;
        zzdqf2.zzaxf();
        zzdqf2.zzfk(n);
        int n2 = zzdqf2.zzhkz[n];
        if (n < zzdqf2.size - 1) {
            System.arraycopy(zzdqf2.zzhkz, n + 1, zzdqf2.zzhkz, n, zzdqf2.size - n - 1);
        }
        --zzdqf2.size;
        ++zzdqf2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzam(n, n2);
    }

    @Override
    public final /* synthetic */ zzdqk zzfm(int n) {
        return this.zzgp(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzhky.zzaxe();
    }
}

