/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdpg;
import com.google.android.gms.internal.ads.zzdqx;
import com.google.android.gms.internal.ads.zzdrd;
import com.google.android.gms.internal.ads.zzdss;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdqi
extends zzdpg<Double>
implements zzdrd<Double>,
zzdss,
RandomAccess {
    private static final zzdqi zzhhg = new zzdqi(new double[0], 0);
    private double[] zzhhh;
    private int size;

    zzdqi() {
        this(new double[10], 0);
    }

    private zzdqi(double[] dArray, int n) {
        this.zzhhh = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhhh, n2, this.zzhhh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdqi)) {
            return super.equals(object);
        }
        zzdqi zzdqi2 = (zzdqi)object;
        if (this.size != zzdqi2.size) {
            return false;
        }
        double[] dArray = zzdqi2.zzhhh;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhhh[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhhh[i]);
            n = n * 31 + zzdqx.zzfk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzaxk();
        if (this.size == this.zzhhh.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhhh, 0, dArray, 0, this.size);
            this.zzhhh = dArray;
        }
        this.zzhhh[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaxk();
        zzdqx.checkNotNull(collection);
        if (!(collection instanceof zzdqi)) {
            return super.addAll(collection);
        }
        zzdqi zzdqi2 = (zzdqi)collection;
        if (zzdqi2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdqi2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdqi2.size;
        if (n > this.zzhhh.length) {
            this.zzhhh = Arrays.copyOf(this.zzhhh, n);
        }
        System.arraycopy(zzdqi2.zzhhh, 0, this.zzhhh, this.size, zzdqi2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhhh[i])) continue;
            System.arraycopy(this.zzhhh, i + 1, this.zzhhh, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdqi zzdqi2 = this;
        zzdqi2.zzaxk();
        zzdqi2.zzfj(n);
        double d3 = zzdqi2.zzhhh[n];
        zzdqi2.zzhhh[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdqi zzdqi2 = this;
        zzdqi2.zzaxk();
        zzdqi2.zzfj(n);
        double d = zzdqi2.zzhhh[n];
        if (n < zzdqi2.size - 1) {
            System.arraycopy(zzdqi2.zzhhh, n + 1, zzdqi2.zzhhh, n, zzdqi2.size - n - 1);
        }
        --zzdqi2.size;
        ++zzdqi2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdqi zzdqi2 = this;
        zzdqi2.zzaxk();
        if (n < 0 || n > zzdqi2.size) {
            throw new IndexOutOfBoundsException(zzdqi2.zzfk(n));
        }
        if (zzdqi2.size < zzdqi2.zzhhh.length) {
            System.arraycopy(zzdqi2.zzhhh, n, zzdqi2.zzhhh, n + 1, zzdqi2.size - n);
        } else {
            double[] dArray = new double[zzdqi2.size * 3 / 2 + 1];
            System.arraycopy(zzdqi2.zzhhh, 0, dArray, 0, n);
            System.arraycopy(zzdqi2.zzhhh, n, dArray, n + 1, zzdqi2.size - n);
            zzdqi2.zzhhh = dArray;
        }
        zzdqi2.zzhhh[n] = d2;
        ++zzdqi2.size;
        ++zzdqi2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzd(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzdrd zzfl(int n) {
        int n2 = n;
        zzdqi zzdqi2 = this;
        if (n2 < zzdqi2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdqi(Arrays.copyOf(zzdqi2.zzhhh, n2), zzdqi2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdqi zzdqi2 = this;
        zzdqi2.zzfj(n);
        return zzdqi2.zzhhh[n];
    }

    static {
        zzhhg.zzaxj();
    }
}

