/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.zza;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.ads.identifier.zzd;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.ads_identifier.zze;
import com.google.android.gms.internal.ads_identifier.zzf;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AdvertisingIdClient {
    private static final Object zzg = new Object();
    private static volatile AdvertisingIdClient zzh;
    @Nullable
    BlockingServiceConnection zza;
    @Nullable
    zzf zzb;
    boolean zzc;
    final Object zzd = new Object();
    @Nullable
    zzb zze;
    private final Context zzi;
    final long zzf;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static Info getAdvertisingIdInfo(@NonNull Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        Object object2;
        AdvertisingIdClient advertisingIdClient = zzh;
        if (advertisingIdClient == null) {
            object2 = zzg;
            synchronized (object2) {
                advertisingIdClient = zzh;
                if (advertisingIdClient == null) {
                    Log.d((String)"AdvertisingIdClient", (String)"Creating AdvertisingIdClient");
                    advertisingIdClient = zzh = new AdvertisingIdClient((Context)object);
                }
            }
        }
        Log.d((String)"AdvertisingIdClient", (String)"AdvertisingIdClient already created.");
        object2 = com.google.android.gms.ads.identifier.zzd.zza(object);
        long l = SystemClock.elapsedRealtime();
        try {
            object = advertisingIdClient.zzf(-1);
            long l2 = SystemClock.elapsedRealtime() - l;
            advertisingIdClient.zze((Info)object, true, 0.0f, l2, "", null);
            long l3 = System.currentTimeMillis();
            long l4 = SystemClock.elapsedRealtime();
            long l5 = l4 - l;
            ((zzd)object2).zzc(35401, 0, l, l3, (int)l5);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GetInfoInternal elapse ");
            stringBuilder.append(l2);
            stringBuilder.append("ms");
            Log.i((String)"AdvertisingIdClient", (String)stringBuilder.toString());
            return object;
        }
        catch (Throwable throwable) {
            advertisingIdClient.zze(null, true, 0.0f, -1L, "", throwable);
            int n = throwable instanceof IOException ? 1 : (throwable instanceof GooglePlayServicesNotAvailableException ? 9 : (throwable instanceof GooglePlayServicesRepairableException ? 16 : (throwable instanceof IllegalStateException ? 8 : -1)));
            ((zzd)object2).zzc(35401, n, l, System.currentTimeMillis(), (int)(SystemClock.elapsedRealtime() - l));
            throw throwable;
        }
    }

    @KeepForSdk
    @NonNull
    public Info getInfo() throws IOException {
        return this.zzf(-1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public AdvertisingIdClient(@NonNull Context context) {
        this((Context)var1_1, 30000L, false, false);
        void var1_1;
    }

    @VisibleForTesting
    public AdvertisingIdClient(@NonNull Context context, long l, boolean bl, boolean bl2) {
        Preconditions.checkNotNull((Object)context);
        this.zzi = context.getApplicationContext();
        this.zzc = false;
        this.zzf = l;
    }

    protected final void finalize() throws Throwable {
        this.zza();
        super.finalize();
    }

    @KeepForSdk
    @ShowFirstParty
    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    @KeepForSdk
    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzc(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static boolean getIsAdIdFakeForDebugLogging(@NonNull Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        boolean bl;
        Context context2;
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context2, -1L, false, false);
        try {
            advertisingIdClient.zzc(false);
            Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
            // MONITORENTER : advertisingIdClient
        }
        catch (Throwable throwable) {
            advertisingIdClient.zza();
            throw throwable;
        }
        advertisingIdClient.zzd();
        Preconditions.checkNotNull((Object)advertisingIdClient.zza);
        Preconditions.checkNotNull((Object)advertisingIdClient.zzb);
        try {
            bl = advertisingIdClient.zzb.zzd();
            // MONITOREXIT : advertisingIdClient
        }
        catch (RemoteException remoteException) {}
        advertisingIdClient.zzb();
        advertisingIdClient.zza();
        return bl;
        Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
        throw new IOException("Remote exception", remoteException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Info zzf(int n) throws IOException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            this.zzd();
            Preconditions.checkNotNull((Object)this.zza);
            Preconditions.checkNotNull((Object)this.zzb);
            try {
                Info info = new Info(this.zzb.zzc(), this.zzb.zze(true));
                // MONITOREXIT @DISABLED, blocks:[1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : this
                this.zzb();
                return info;
            }
            catch (RemoteException remoteException) {}
            Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
            throw new IOException("Remote exception", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            Context context = this.zzi;
            if (context == null || (context = this.zza) == null) {
                return;
            }
            try {
                boolean bl = this.zzc;
                if (bl) {
                    ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
                    Context context2 = this.zzi;
                    BlockingServiceConnection blockingServiceConnection = this.zza;
                    connectionTracker.unbindService(context2, (ServiceConnection)blockingServiceConnection);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzc = false;
            this.zzb = null;
            this.zza = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final void zzb() {
        Object object = this.zzd;
        synchronized (object) {
            long l;
            zzb zzb2 = this.zze;
            if (zzb2 != null) {
                zzb2.zza.countDown();
                try {
                    this.zze.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((l = this.zzf) > 0L) {
                this.zze = zzb2 = new zzb(this, l);
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected final void zzc(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        if (bl) {
            this.zzb();
        }
        synchronized (this) {
            bl = this.zzc;
            if (bl) {
                return;
            }
            Context context = this.zzi;
            try {
                context.getPackageManager().getPackageInfo("com.android.vending", 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new GooglePlayServicesNotAvailableException(9);
            }
            switch (GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000)) {
                case 0: 
                case 2: {
                    String string = "com.google.android.gms.ads.identifier.service.START";
                    BlockingServiceConnection blockingServiceConnection = new BlockingServiceConnection();
                    Intent intent = new Intent(string);
                    intent.setPackage("com.google.android.gms");
                    boolean bl2 = ConnectionTracker.getInstance().bindService(context, intent, (ServiceConnection)blockingServiceConnection, 1);
                    if (!bl2) throw new IOException("Connection failure");
                    Object object = this.zza = blockingServiceConnection;
                    object = object.getServiceWithTimeout(10000L, TimeUnit.MILLISECONDS);
                    object = com.google.android.gms.internal.ads_identifier.zze.zza((IBinder)object);
                    this.zzb = object;
                    this.zzc = true;
                    return;
                }
                default: {
                    throw new IOException("Google Play services not available");
                }
            }
            catch (Throwable throwable) {
                throw new IOException(throwable);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted exception");
            }
            catch (Throwable throwable) {
                throw new IOException(throwable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final synchronized void zzd() throws IOException {
        if (this.zzc) return;
        try {
            Log.d((String)"AdvertisingIdClient", (String)"AdvertisingIdClient is not bounded. Starting to bind it...");
            this.zzc(false);
            Log.d((String)"AdvertisingIdClient", (String)"AdvertisingIdClient is bounded");
            if (this.zzc) return;
        }
        catch (Exception exception) {
            throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
        }
        throw new IOException("AdvertisingIdClient cannot reconnect.");
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final boolean zze(@Nullable Info object, boolean bl, float f, long l, String string, @Nullable Throwable throwable) {
        if (Math.random() > 0.0) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", "1");
        if (object != null) {
            String string2 = true != ((Info)object).isLimitAdTrackingEnabled() ? "0" : "1";
            hashMap.put("limit_ad_tracking", string2);
            object = ((Info)object).getId();
            if (object != null) {
                int n = ((String)object).length();
                hashMap.put("ad_id_size", Integer.toString(n));
            }
        }
        if (throwable != null) {
            Class<?> clazz = throwable.getClass();
            hashMap.put("error", clazz.getName());
        }
        hashMap.put("tag", "AdvertisingIdClient");
        String string3 = Long.toString(l);
        hashMap.put("time_spent", string3);
        new zza(this, hashMap).start();
        return true;
    }

    @KeepForSdkWithMembers
    public static final class Info {
        @Nullable
        private final String zza;
        private final boolean zzb;

        @Nullable
        public String getId() {
            return this.zza;
        }

        @NonNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append(this.zza);
            stringBuilder.append("}");
            stringBuilder.append(this.zzb);
            return stringBuilder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Info(@Nullable String advertisingId, boolean limitAdTrackingEnabled) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzb;
        }
    }
}

