/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzqf;

public class AdLoader {
    private final zzef zzrw;
    private final Context mContext;
    private final zzeq zzrx;

    AdLoader(Context context, zzeq zzeq2) {
        this(context, zzeq2, zzef.zzeD());
    }

    AdLoader(Context context, zzeq zzeq2, zzef zzef2) {
        this.mContext = context;
        this.zzrx = zzeq2;
        this.zzrw = zzef2;
    }

    private void zza(zzfe zzfe2) {
        try {
            this.zzrx.zzf(this.zzrw.zza(this.mContext, zzfe2));
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to load ad.", remoteException);
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzbp());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzbp());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzrx.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzrx.isLoading();
        }
        catch (RemoteException remoteException) {
            zzqf.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzer zzry;

        public Builder(Context context, String string) {
            this((Context)zzac.zzb((Object)context, (Object)"context cannot be null"), zzel.zzeU().zzb(context, string, new zzjz()));
        }

        Builder(Context context, zzer zzer2) {
            this.mContext = context;
            this.zzry = zzer2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzry.zza(new zzhv(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzry.zza(new zzhu(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzry.zza(string, new zzhx(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzhw(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzry.zzb(new zzdz(adListener));
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzry.zza(new zzhc(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzac.zzw((Object)correlator);
            try {
                this.zzry.zzb(correlator.zzbq());
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzry.zzck());
            }
            catch (RemoteException remoteException) {
                zzqf.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

