/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqf;
import java.util.List;

@zzme
public class zzho
implements NativeCustomTemplateAd {
    private final zzhn zzHw;
    private final MediaView zzHx;
    private final VideoController zzAl = new VideoController();

    public zzho(zzhn zzhn2) {
        this.zzHw = zzhn2;
        Context context = null;
        try {
            context = (Context)zzd.zzF((IObjectWrapper)zzhn2.zzfW());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzqf.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            mediaView = this.zzq(context);
            try {
                if (!this.zzHw.zzj(zzd.zzA((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzqf.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzHx = mediaView;
    }

    protected MediaView zzq(Context context) {
        return new MediaView(context);
    }

    @Override
    public CharSequence getText(String string) {
        try {
            return this.zzHw.zzY(string);
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public NativeAd.Image getImage(String string) {
        try {
            zzhf zzhf2 = this.zzHw.zzZ(string);
            if (zzhf2 != null) {
                return new zzhg(zzhf2);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public VideoController getVideoController() {
        try {
            zzfa zzfa2 = this.zzHw.zzbF();
            if (zzfa2 != null) {
                this.zzAl.zza(zzfa2);
            }
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzAl;
    }

    @Override
    public MediaView getVideoMediaView() {
        return this.zzHx;
    }

    @Override
    public List<String> getAvailableAssetNames() {
        try {
            return this.zzHw.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public String getCustomTemplateId() {
        try {
            return this.zzHw.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public void performClick(String string) {
        try {
            this.zzHw.performClick(string);
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to perform click.", remoteException);
        }
    }

    @Override
    public void recordImpression() {
        try {
            this.zzHw.recordImpression();
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to record impression.", remoteException);
        }
    }

    @Override
    public void destroy() {
        try {
            this.zzHw.destroy();
        }
        catch (RemoteException remoteException) {
            zzqf.zzb("Failed to destroy ad.", remoteException);
        }
    }
}

