/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzks;
import java.util.Date;
import java.util.Set;

@zzaaz
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzamv {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzcP;
    private InterstitialAd zzcQ;
    private AdLoader zzcR;
    private Context zzcS;
    private InterstitialAd zzcT;
    private MediationRewardedVideoAdListener zzcU;
    private RewardedVideoAdListener zzcV = new com.google.ads.mediation.zza(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzji.zzdr();
            builder.addTestDevice(zzakk.zzV(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzcP != null) {
            this.zzcP.destroy();
            this.zzcP = null;
        }
        if (this.zzcQ != null) {
            this.zzcQ = null;
        }
        if (this.zzcR != null) {
            this.zzcR = null;
        }
        if (this.zzcT != null) {
            this.zzcT = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzcP != null) {
            this.zzcP.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzcP != null) {
            this.zzcP.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcP = new AdView(context);
        this.zzcP.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzcP.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcP.setAdListener(new zzc(this, mediationBannerListener));
        this.zzcP.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzcP;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcQ = new InterstitialAd(context);
        this.zzcQ.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcQ.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzcQ.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzcQ != null) {
            this.zzcQ.setImmersiveMode(bl);
        }
        if (this.zzcT != null) {
            this.zzcT.setImmersiveMode(bl);
        }
    }

    @Override
    public zzks getVideoController() {
        VideoController videoController;
        if (this.zzcP != null && (videoController = this.zzcP.getVideoController()) != null) {
            return videoController.zzad();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzcQ.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzB(1).zzjg();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzfy()) {
            for (String string2 : nativeMediationAdRequest.zzfz().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzfz().get(string2) != false ? zze2 : null);
            }
        }
        this.zzcR = builder.build();
        this.zzcR.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzcS = context.getApplicationContext();
        this.zzcU = mediationRewardedVideoAdListener;
        this.zzcU.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzcS == null || this.zzcU == null) {
            zzako.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzcT = new InterstitialAd(this.zzcS);
        this.zzcT.zza(true);
        this.zzcT.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcT.setRewardedVideoAdListener(this.zzcV);
        this.zzcT.loadAd(this.zza(this.zzcS, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzcT.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzcU != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzcU;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzcT = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzcY;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzcY = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcY);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzcX;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcX = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcX);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener {
        private AbstractAdViewAdapter zzcZ;
        private MediationNativeListener zzdc;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzcZ = abstractAdViewAdapter;
            this.zzdc = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzdc.onAdFailedToLoad(this.zzcZ, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzdc.onAdOpened(this.zzcZ);
        }

        @Override
        public final void onAdClosed() {
            this.zzdc.onAdClosed(this.zzcZ);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzdc.onAdLeftApplication(this.zzcZ);
        }

        @Override
        public final void onAdClicked() {
            this.zzdc.onAdClicked(this.zzcZ);
        }

        @Override
        public final void onAdImpression() {
            this.zzdc.onAdImpression(this.zzcZ);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzdc.onAdLoaded(this.zzcZ, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzdc.onAdLoaded(this.zzcZ, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzdc.zza(this.zzcZ, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzdc.zza(this.zzcZ, nativeCustomTemplateAd, string);
        }
    }

    static final class zzd
    extends AdListener
    implements zzim {
        private AbstractAdViewAdapter zzcZ;
        private MediationInterstitialListener zzdb;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzcZ = abstractAdViewAdapter;
            this.zzdb = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzdb.onAdLoaded(this.zzcZ);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzdb.onAdFailedToLoad(this.zzcZ, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzdb.onAdOpened(this.zzcZ);
        }

        @Override
        public final void onAdClosed() {
            this.zzdb.onAdClosed(this.zzcZ);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzdb.onAdLeftApplication(this.zzcZ);
        }

        @Override
        public final void onAdClicked() {
            this.zzdb.onAdClicked(this.zzcZ);
        }
    }

    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzim {
        private AbstractAdViewAdapter zzcZ;
        private MediationBannerListener zzda;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzcZ = abstractAdViewAdapter;
            this.zzda = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzda.onAdLoaded(this.zzcZ);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzda.onAdFailedToLoad(this.zzcZ, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzda.onAdOpened(this.zzcZ);
        }

        @Override
        public final void onAdClosed() {
            this.zzda.onAdClosed(this.zzcZ);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzda.onAdLeftApplication(this.zzcZ);
        }

        @Override
        public final void onAdClicked() {
            this.zzda.onAdClicked(this.zzcZ);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzda.zza(this.zzcZ, string, string2);
        }
    }
}

