/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzwc;

public class AdLoader {
    private final zziu zzrT;
    private final Context mContext;
    private final zzjr zzrU;

    AdLoader(Context context, zzjr zzjr2) {
        this(context, zzjr2, zziu.zzAu);
    }

    private AdLoader(Context context, zzjr zzjr2, zziu zziu2) {
        this.mContext = context;
        this.zzrU = zzjr2;
        this.zzrT = zziu2;
    }

    private final void zza(zzla zzla2) {
        try {
            this.zzrU.zzc(zziu.zza(this.mContext, zzla2));
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzaa());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzaa());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzrU.zzaH();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzrU.isLoading();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzju zzrV;

        public Builder(Context context, String string) {
            this((Context)zzbr.zzb((Object)context, (Object)"context cannot be null"), zzji.zzds().zzb(context, string, new zzwc()));
        }

        private Builder(Context context, zzju zzju2) {
            this.mContext = context;
            this.zzrV = zzju2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzrV.zza(new zzqe(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzrV.zza(new zzqd(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzrV.zza(string, new zzqg(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzqf(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zziv zziv2 = new zziv(this.mContext, adSizeArray);
                this.zzrV.zza(new zzqh(onPublisherAdViewLoadedListener), zziv2);
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzrV.zzb(new zzio(adListener));
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzrV.zza(new zzon(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzrV.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzbr.zzu((Object)correlator);
            try {
                this.zzrV.zzb(correlator.zzab());
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzrV.zzaY());
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

