/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzlw;

@zzaaz
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @Nullable
    private zzks zzsg;
    @Nullable
    private VideoLifecycleCallbacks zzsh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzks zzks2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzsg = zzks2;
            if (this.zzsh != null) {
                this.setVideoLifecycleCallbacks(this.zzsh);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzks zzad() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return;
            }
            try {
                this.zzsg.play();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return;
            }
            try {
                this.zzsg.pause();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return;
            }
            try {
                this.zzsg.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return true;
            }
            try {
                return this.zzsg.isMuted();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return 0;
            }
            try {
                return this.zzsg.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return false;
            }
            try {
                return this.zzsg.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        zzbr.zzb((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzsh = videoLifecycleCallbacks;
            if (this.zzsg == null) {
                return;
            }
            try {
                this.zzsg.zza(new zzlw(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsg != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsg == null) {
                return 0.0f;
            }
            try {
                return this.zzsg.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzako.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

