/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zze;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zziv;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.StringTokenizer;

@zzaaz
public final class zzakk {
    public static final Handler zzaaJ = new Handler(Looper.getMainLooper());
    private static final String zzaaK = AdView.class.getName();
    private static final String zzaaL = InterstitialAd.class.getName();
    private static final String zzaaM = PublisherAdView.class.getName();
    private static final String zzaaN = PublisherInterstitialAd.class.getName();
    private static final String zzaaO = SearchAdView.class.getName();
    private static final String zzaaP = AdLoader.class.getName();

    public static void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static int zzc(Context context, int n) {
        return zzakk.zza(context.getResources().getDisplayMetrics(), n);
    }

    public static int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public static int zzd(Context context, int n) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return zzakk.zzb(displayMetrics, n);
    }

    public static int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public final void zza(ViewGroup viewGroup, zziv zziv2, String string, String string2) {
        zzako.zzaT(string2);
        this.zza(viewGroup, zziv2, string, -65536, -16777216);
    }

    public final void zza(ViewGroup viewGroup, zziv zziv2, String string) {
        this.zza(viewGroup, zziv2, string, -16777216, -1);
    }

    private final void zza(ViewGroup viewGroup, zziv zziv2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzakk.zzc(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zziv2.widthPixels - n3, zziv2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zziv2.widthPixels, zziv2.heightPixels);
    }

    public static String zzV(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return zzakk.zzaR(string == null || zzakk.zzij() ? "emulator" : string);
    }

    @Nullable
    public static String zzW(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static boolean zzij() {
        return Build.DEVICE.startsWith("generic");
    }

    public static boolean zzik() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String zzaR(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        return null;
    }

    public static boolean zzX(Context context) {
        return 0 == zze.zzoU().isGooglePlayServicesAvailable(context);
    }

    public static int zzP(Context context) {
        return DynamiteModule.zzG((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zzQ(Context context) {
        return DynamiteModule.zzF((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static boolean zzY(Context context) {
        int n = zze.zzoU().isGooglePlayServicesAvailable(context);
        return n == 0 || n == 2;
    }

    public static boolean zzZ(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public static boolean zzaa(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (zzs.zzrZ()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public static int zzab(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    public static String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzaaK.equalsIgnoreCase(string3) || zzaaL.equalsIgnoreCase(string3) || zzaaM.equalsIgnoreCase(string3) || zzaaN.equalsIgnoreCase(string3) || zzaaO.equalsIgnoreCase(string3) || zzaaP.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5;
            String string6;
            int n2 = 3;
            String string7 = ".";
            String string8 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string8, string7);
            StringBuilder stringBuilder = new StringBuilder();
            --n2;
            if (!stringTokenizer.hasMoreElements()) {
                string6 = string8;
            } else {
                stringBuilder.append(stringTokenizer.nextToken());
                while (n2-- > 0 && stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(".").append(stringTokenizer.nextToken());
                }
                string6 = string5 = stringBuilder.toString();
            }
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        zzakk.zza(context, null, string2, bundle, true, new zzakl(this));
    }

    public static void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zzakn zzakn2) {
        Context context2;
        if (bl) {
            context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            bundle.putString("os", Build.VERSION.RELEASE);
            bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
            bundle.putString("appid", context2.getPackageName());
            if (string == null) {
                zze.zzoU();
                int n = zze.zzau((Context)context);
                string = new StringBuilder(23).append(n).append(".11010000").toString();
            }
            bundle.putString("js", string);
        }
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzakn2.zzaN(context2.toString());
    }
}

