/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaet;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzwd;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyj;

@zzaaz
public class zziz {
    private zzkh zzAC;
    private final Object mLock = new Object();
    private final zziq zzAD;
    private final zzip zzAE;
    private final zzli zzAF;
    private final zzqc zzAG;
    private final zzaet zzAH;
    private final zzyi zzAI;

    public zziz(zziq zziq2, zzip zzip2, zzli zzli2, zzqc zzqc2, zzaet zzaet2, zzyi zzyi2) {
        this.zzAD = zziq2;
        this.zzAE = zzip2;
        this.zzAF = zzli2;
        this.zzAG = zzqc2;
        this.zzAH = zzaet2;
        this.zzAI = zzyi2;
    }

    @Nullable
    private static zzkh zzdl() {
        try {
            Object obj = zziz.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzako.zzaT("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzki.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzako.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzkh zzdm() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzAC == null) {
                this.zzAC = zziz.zzdl();
            }
            return this.zzAC;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl) {
            zzji.zzdr();
            if (!zzakk.zzX(context)) {
                zzako.zzaC("Google Play Services is not available");
                bl = true;
            }
        }
        zzji.zzdr();
        int n = zzakk.zzQ(context);
        zzji.zzdr();
        if (n > zzakk.zzP(context)) {
            bl = true;
        }
        if (bl) {
            t = zza2.zzdo();
            if (t == null) {
                t = zza2.zzdp();
            }
        } else {
            t = zza2.zzdp();
            if (t == null) {
                t = zza2.zzdo();
            }
        }
        return t;
    }

    private static void zzb(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzji.zzdr().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzju zzb(Context context, String string, zzwd zzwd2) {
        return zziz.zza(context, false, new zzjd(this, context, string, zzwd2));
    }

    public final zzow zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        return zziz.zza(context, false, new zzjf(this, frameLayout, frameLayout2, context));
    }

    @Nullable
    public final zzyj zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzako.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        boolean bl2 = bl;
        return zziz.zza((Context)activity, bl2, new zzjh(this, activity));
    }

    static /* synthetic */ zziq zzb(zziz zziz2) {
        return zziz2.zzAD;
    }

    static /* synthetic */ void zza(zziz zziz2, Context context, String string) {
        zziz.zzb(context, string);
    }

    static /* synthetic */ zzip zzc(zziz zziz2) {
        return zziz2.zzAE;
    }

    static /* synthetic */ zzli zzd(zziz zziz2) {
        return zziz2.zzAF;
    }

    static /* synthetic */ zzqc zze(zziz zziz2) {
        return zziz2.zzAG;
    }

    static /* synthetic */ zzaet zzf(zziz zziz2) {
        return zziz2.zzAH;
    }

    static /* synthetic */ zzyi zzg(zziz zziz2) {
        return zziz2.zzAI;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zziz zzAL;

        zza(zziz zziz2) {
            this.zzAL = zziz2;
        }

        @Nullable
        protected abstract T zza(zzkh var1) throws RemoteException;

        @Nullable
        protected abstract T zzdn() throws RemoteException;

        @Nullable
        protected final T zzdo() {
            zzkh zzkh2 = this.zzAL.zzdm();
            if (zzkh2 == null) {
                zzako.zzaT("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzkh2);
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzdp() {
            try {
                return this.zzdn();
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

