/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpj;
import java.util.List;

@zzaaz
public final class zzpm
implements NativeCustomTemplateAd {
    private final zzpj zzIM;
    private final MediaView zzIN;
    private final VideoController zzBg = new VideoController();

    public zzpm(zzpj zzpj2) {
        this.zzIM = zzpj2;
        Context context = null;
        try {
            context = (Context)zzn.zzE((IObjectWrapper)zzpj2.zzem());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzako.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzIM.zzj(zzn.zzw((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzako.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzIN = mediaView;
    }

    public final zzpj zzew() {
        return this.zzIM;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzIM.zzP(string);
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzos zzos2 = this.zzIM.zzQ(string);
            if (zzos2 != null) {
                return new zzov(zzos2);
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzks zzks2 = this.zzIM.getVideoController();
            if (zzks2 != null) {
                this.zzBg.zza(zzks2);
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzBg;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzIN;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzIM.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzIM.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzIM.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzIM.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzIM.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

