/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzzm;
import java.util.List;

@zzzm
public final class zzpm
implements NativeCustomTemplateAd {
    private final zzpj zzIL;
    private final MediaView zzIM;
    private final VideoController zzBf = new VideoController();

    public zzpm(zzpj zzpj2) {
        this.zzIL = zzpj2;
        Context context = null;
        try {
            context = (Context)zzn.zzE((IObjectWrapper)zzpj2.zzen());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzajb.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzIL.zzj(zzn.zzw((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzajb.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzIM = mediaView;
    }

    public final zzpj zzex() {
        return this.zzIL;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzIL.zzP(string);
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzos zzos2 = this.zzIL.zzQ(string);
            if (zzos2 != null) {
                return new zzov(zzos2);
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzks zzks2 = this.zzIL.getVideoController();
            if (zzks2 != null) {
                this.zzBf.zza(zzks2);
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzBf;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzIM;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzIL.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzIL.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzIL.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzIL.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzIL.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

