/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.MediationServerParameters;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.customevent.CustomEventAdapter;
import com.google.ads.mediation.customevent.CustomEventServerParameters;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.mediation.customevent.CustomEventExtras;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzvo;
import com.google.android.gms.internal.zzzm;
import java.util.Map;

@zzzm
public final class zzup
extends zzur {
    private Map<Class<? extends NetworkExtras>, NetworkExtras> zzNa;

    @Override
    public final zzut zzah(String string) throws RemoteException {
        return this.zzaj(string);
    }

    @Override
    public final boolean zzai(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzup.class.getClassLoader());
            return CustomEvent.class.isAssignableFrom(clazz);
        }
        catch (Throwable throwable) {
            zzajb.zzaT(new StringBuilder(80 + String.valueOf(string).length()).append("Could not load custom event implementation class: ").append(string).append(", assuming old implementation.").toString());
            return false;
        }
    }

    public final void zzg(Map<Class<? extends NetworkExtras>, NetworkExtras> map) {
        this.zzNa = map;
    }

    private final <NETWORK_EXTRAS extends com.google.ads.mediation.NetworkExtras, SERVER_PARAMETERS extends MediationServerParameters> zzut zzaj(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzup.class.getClassLoader());
            if (com.google.ads.mediation.MediationAdapter.class.isAssignableFrom(clazz)) {
                com.google.ads.mediation.MediationAdapter mediationAdapter = (com.google.ads.mediation.MediationAdapter)clazz.newInstance();
                com.google.ads.mediation.NetworkExtras networkExtras = (com.google.ads.mediation.NetworkExtras)this.zzNa.get(mediationAdapter.getAdditionalParametersType());
                return new zzvo(mediationAdapter, networkExtras);
            }
            if (MediationAdapter.class.isAssignableFrom(clazz)) {
                MediationAdapter mediationAdapter = (MediationAdapter)clazz.newInstance();
                return new zzvj(mediationAdapter);
            }
            zzajb.zzaT(new StringBuilder(64 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(" (not a valid adapter).").toString());
            throw new RemoteException();
        }
        catch (Throwable throwable) {
            return this.zzak(string);
        }
    }

    private final zzut zzak(String string) throws RemoteException {
        try {
            zzajb.zzaC("Reflection failed, retrying using direct instantiation");
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                return new zzvj(new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(string)) {
                return new zzvj(new AdUrlAdapter());
            }
            if ("com.google.android.gms.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                return new zzvj(new com.google.android.gms.ads.mediation.customevent.CustomEventAdapter());
            }
            if ("com.google.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                CustomEventAdapter customEventAdapter = new CustomEventAdapter();
                CustomEventExtras customEventExtras = (CustomEventExtras)this.zzNa.get(customEventAdapter.getAdditionalParametersType());
                return new zzvo<CustomEventExtras, CustomEventServerParameters>(customEventAdapter, customEventExtras);
            }
        }
        catch (Throwable throwable) {
            zzajb.zzc(new StringBuilder(43 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(". ").toString(), throwable);
        }
        throw new RemoteException();
    }
}

