/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzzm;
import java.util.Date;
import java.util.Set;

@zzzm
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzali {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzcO;
    private InterstitialAd zzcP;
    private AdLoader zzcQ;
    private Context zzcR;
    private InterstitialAd zzcS;
    private MediationRewardedVideoAdListener zzcT;
    private RewardedVideoAdListener zzcU = new com.google.ads.mediation.zza(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzji.zzds();
            builder.addTestDevice(zzaix.zzV(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzcO != null) {
            this.zzcO.destroy();
            this.zzcO = null;
        }
        if (this.zzcP != null) {
            this.zzcP = null;
        }
        if (this.zzcQ != null) {
            this.zzcQ = null;
        }
        if (this.zzcS != null) {
            this.zzcS = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzcO != null) {
            this.zzcO.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzcO != null) {
            this.zzcO.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcO = new AdView(context);
        this.zzcO.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzcO.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcO.setAdListener(new zzc(this, mediationBannerListener));
        this.zzcO.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzcO;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcP = new InterstitialAd(context);
        this.zzcP.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcP.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzcP.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzcP != null) {
            this.zzcP.setImmersiveMode(bl);
        }
        if (this.zzcS != null) {
            this.zzcS.setImmersiveMode(bl);
        }
    }

    @Override
    public zzks getVideoController() {
        VideoController videoController;
        if (this.zzcO != null && (videoController = this.zzcO.getVideoController()) != null) {
            return videoController.zzae();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzcP.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzB(1).zzjh();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzfz()) {
            for (String string2 : nativeMediationAdRequest.zzfA().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzfA().get(string2) != false ? zze2 : null);
            }
        }
        this.zzcQ = builder.build();
        this.zzcQ.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzcR = context.getApplicationContext();
        this.zzcT = mediationRewardedVideoAdListener;
        this.zzcT.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzcR == null || this.zzcT == null) {
            zzajb.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzcS = new InterstitialAd(this.zzcR);
        this.zzcS.zza(true);
        this.zzcS.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcS.setRewardedVideoAdListener(this.zzcU);
        this.zzcS.loadAd(this.zza(this.zzcR, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzcS.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzcT != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzcT;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzcS = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzcX;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzcX = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcX);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzcW;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcW = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcW);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener {
        private AbstractAdViewAdapter zzcY;
        private MediationNativeListener zzdb;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzcY = abstractAdViewAdapter;
            this.zzdb = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzdb.onAdFailedToLoad(this.zzcY, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzdb.onAdOpened(this.zzcY);
        }

        @Override
        public final void onAdClosed() {
            this.zzdb.onAdClosed(this.zzcY);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzdb.onAdLeftApplication(this.zzcY);
        }

        @Override
        public final void onAdClicked() {
            this.zzdb.onAdClicked(this.zzcY);
        }

        @Override
        public final void onAdImpression() {
            this.zzdb.onAdImpression(this.zzcY);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzdb.onAdLoaded(this.zzcY, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzdb.onAdLoaded(this.zzcY, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzdb.zza(this.zzcY, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzdb.zza(this.zzcY, nativeCustomTemplateAd, string);
        }
    }

    static final class zzd
    extends AdListener
    implements zzim {
        private AbstractAdViewAdapter zzcY;
        private MediationInterstitialListener zzda;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzcY = abstractAdViewAdapter;
            this.zzda = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzda.onAdLoaded(this.zzcY);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzda.onAdFailedToLoad(this.zzcY, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzda.onAdOpened(this.zzcY);
        }

        @Override
        public final void onAdClosed() {
            this.zzda.onAdClosed(this.zzcY);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzda.onAdLeftApplication(this.zzcY);
        }

        @Override
        public final void onAdClicked() {
            this.zzda.onAdClicked(this.zzcY);
        }
    }

    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzim {
        private AbstractAdViewAdapter zzcY;
        private MediationBannerListener zzcZ;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzcY = abstractAdViewAdapter;
            this.zzcZ = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzcZ.onAdLoaded(this.zzcY);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzcZ.onAdFailedToLoad(this.zzcY, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzcZ.onAdOpened(this.zzcY);
        }

        @Override
        public final void onAdClosed() {
            this.zzcZ.onAdClosed(this.zzcY);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzcZ.onAdLeftApplication(this.zzcY);
        }

        @Override
        public final void onAdClicked() {
            this.zzcZ.onAdClicked(this.zzcY);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzcZ.zza(this.zzcY, string, string2);
        }
    }
}

