/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;

public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    public static final AdSize BANNER = new AdSize(320, 50, "320x50_mb");
    public static final AdSize FULL_BANNER = new AdSize(468, 60, "468x60_as");
    public static final AdSize LARGE_BANNER = new AdSize(320, 100, "320x100_as");
    public static final AdSize LEADERBOARD = new AdSize(728, 90, "728x90_as");
    public static final AdSize MEDIUM_RECTANGLE = new AdSize(300, 250, "300x250_as");
    public static final AdSize WIDE_SKYSCRAPER = new AdSize(160, 600, "160x600_as");
    public static final AdSize SMART_BANNER = new AdSize(-1, -2, "smart_banner");
    public static final AdSize FLUID = new AdSize(-3, -4, "fluid");
    public static final AdSize zzrX = new AdSize(50, 50, "50x50_mb");
    public static final AdSize SEARCH = new AdSize(-3, 0, "search_v2");
    private final int zzrY;
    private final int zzrZ;
    private final String zzsa;

    public AdSize(int n, int n2) {
        String string = n == -1 ? "FULL" : String.valueOf(n);
        String string2 = n2 == -2 ? "AUTO" : String.valueOf(n2);
        String string3 = String.valueOf("_as");
        this(n, n2, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("x").append(string2).append(string3).toString());
    }

    AdSize(int n, int n2, String string) {
        if (n < 0 && n != -1 && n != -3) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Invalid width for AdSize: ").append(n).toString());
        }
        if (n2 < 0 && n2 != -2 && n2 != -4) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid height for AdSize: ").append(n2).toString());
        }
        this.zzrY = n;
        this.zzrZ = n2;
        this.zzsa = string;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdSize)) {
            return false;
        }
        AdSize adSize = (AdSize)object;
        return this.zzrY == adSize.zzrY && this.zzrZ == adSize.zzrZ && this.zzsa.equals(adSize.zzsa);
    }

    public final int getHeight() {
        return this.zzrZ;
    }

    public final int getHeightInPixels(Context context) {
        switch (this.zzrZ) {
            case -2: {
                return zziv.zzb(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        zzji.zzds();
        return zzaix.zzc(context, this.zzrZ);
    }

    public final int getWidth() {
        return this.zzrY;
    }

    public final int getWidthInPixels(Context context) {
        switch (this.zzrY) {
            case -1: {
                return zziv.zza(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        zzji.zzds();
        return zzaix.zzc(context, this.zzrY);
    }

    public final int hashCode() {
        return this.zzsa.hashCode();
    }

    public final boolean isAutoHeight() {
        return this.zzrZ == -2;
    }

    public final boolean isFullWidth() {
        return this.zzrY == -1;
    }

    public final boolean isFluid() {
        return this.zzrY == -3 && this.zzrZ == -4;
    }

    public final String toString() {
        return this.zzsa;
    }
}

