/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.internal.zzzm;

@zzzm
public final class zziy {
    private final AdSize[] zzAA;
    private final String zztX;

    private static AdSize[] zzC(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                int n;
                int n2;
                String[] stringArray2 = string2.split("[xX]");
                String[] stringArray3 = stringArray2;
                stringArray2[0] = stringArray3[0].trim();
                stringArray3[1] = stringArray3[1].trim();
                try {
                    n2 = "FULL_WIDTH".equals(stringArray3[0]) ? -1 : Integer.parseInt(stringArray3[0]);
                    n = "AUTO_HEIGHT".equals(stringArray3[1]) ? -2 : Integer.parseInt(stringArray3[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = String.valueOf(string2);
                    throw new IllegalArgumentException(string3.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string3) : new String("Could not parse XML attribute \"adSize\": "));
                }
                adSizeArray[i] = new AdSize(n2, n);
                continue;
            }
            if ("BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.BANNER;
                continue;
            }
            if ("LARGE_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.LARGE_BANNER;
                continue;
            }
            if ("FULL_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.FULL_BANNER;
                continue;
            }
            if ("LEADERBOARD".equals(string2)) {
                adSizeArray[i] = AdSize.LEADERBOARD;
                continue;
            }
            if ("MEDIUM_RECTANGLE".equals(string2)) {
                adSizeArray[i] = AdSize.MEDIUM_RECTANGLE;
                continue;
            }
            if ("SMART_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.SMART_BANNER;
                continue;
            }
            if ("WIDE_SKYSCRAPER".equals(string2)) {
                adSizeArray[i] = AdSize.WIDE_SKYSCRAPER;
                continue;
            }
            if ("FLUID".equals(string2)) {
                adSizeArray[i] = AdSize.FLUID;
                continue;
            }
            if ("ICON".equals(string2)) {
                adSizeArray[i] = AdSize.zzrX;
                continue;
            }
            String string4 = String.valueOf(string2);
            throw new IllegalArgumentException(string4.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string4) : new String("Could not parse XML attribute \"adSize\": "));
        }
        if (adSizeArray.length == 0) {
            String string5 = String.valueOf(string);
            throw new IllegalArgumentException(string5.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string5) : new String("Could not parse XML attribute \"adSize\": "));
        }
        return adSizeArray;
    }

    public zziy(Context context, AttributeSet attributeSet) {
        boolean bl;
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.AdsAttrs);
        String string = typedArray.getString(R.styleable.AdsAttrs_adSize);
        String string2 = typedArray.getString(R.styleable.AdsAttrs_adSizes);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)string);
        boolean bl3 = bl = !TextUtils.isEmpty((CharSequence)string2);
        if (bl2 && !bl) {
            this.zzAA = zziy.zzC(string);
        } else if (!bl2 && bl) {
            this.zzAA = zziy.zzC(string2);
        } else {
            if (bl2) {
                throw new IllegalArgumentException("Either XML attribute \"adSize\" or XML attribute \"supportedAdSizes\" should be specified, but not both.");
            }
            throw new IllegalArgumentException("Required XML attribute \"adSize\" was missing.");
        }
        this.zztX = typedArray.getString(R.styleable.AdsAttrs_adUnitId);
        if (TextUtils.isEmpty((CharSequence)this.zztX)) {
            throw new IllegalArgumentException("Required XML attribute \"adUnitId\" was missing.");
        }
    }

    public final AdSize[] zzg(boolean bl) {
        if (!bl && this.zzAA.length != 1) {
            throw new IllegalArgumentException("The adSizes XML attribute is only allowed on PublisherAdViews.");
        }
        return this.zzAA;
    }

    public final String getAdUnitId() {
        return this.zztX;
    }
}

