/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzzm;

@zzzm
public class zziz {
    private zzkh zzAB;
    private final Object mLock = new Object();
    private final zziq zzAC;
    private final zzip zzAD;
    private final zzli zzAE;
    private final zzqc zzAF;
    private final zzadg zzAG;
    private final zzwv zzAH;

    public zziz(zziq zziq2, zzip zzip2, zzli zzli2, zzqc zzqc2, zzadg zzadg2, zzwv zzwv2) {
        this.zzAC = zziq2;
        this.zzAD = zzip2;
        this.zzAE = zzli2;
        this.zzAF = zzqc2;
        this.zzAG = zzadg2;
        this.zzAH = zzwv2;
    }

    @Nullable
    private static zzkh zzdm() {
        try {
            Object obj = zziz.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzajb.zzaT("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzki.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzajb.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzkh zzdn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzAB == null) {
                this.zzAB = zziz.zzdm();
            }
            return this.zzAB;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl) {
            zzji.zzds();
            if (!zzaix.zzX(context)) {
                zzajb.zzaC("Google Play Services is not available");
                bl = true;
            }
        }
        zzji.zzds();
        int n = zzaix.zzQ(context);
        zzji.zzds();
        if (n > zzaix.zzP(context)) {
            bl = true;
        }
        if (bl) {
            t = zza2.zzdp();
            if (t == null) {
                t = zza2.zzdq();
            }
        } else {
            t = zza2.zzdq();
            if (t == null) {
                t = zza2.zzdp();
            }
        }
        return t;
    }

    private static void zzb(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzji.zzds().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzju zzb(Context context, String string, zzuq zzuq2) {
        return zziz.zza(context, false, new zzjd(this, context, string, zzuq2));
    }

    public final zzow zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        return zziz.zza(context, false, new zzjf(this, frameLayout, frameLayout2, context));
    }

    @Nullable
    public final zzww zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzajb.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        boolean bl2 = bl;
        return zziz.zza((Context)activity, bl2, new zzjh(this, activity));
    }

    static /* synthetic */ zziq zzb(zziz zziz2) {
        return zziz2.zzAC;
    }

    static /* synthetic */ void zza(zziz zziz2, Context context, String string) {
        zziz.zzb(context, string);
    }

    static /* synthetic */ zzip zzc(zziz zziz2) {
        return zziz2.zzAD;
    }

    static /* synthetic */ zzli zzd(zziz zziz2) {
        return zziz2.zzAE;
    }

    static /* synthetic */ zzqc zze(zziz zziz2) {
        return zziz2.zzAF;
    }

    static /* synthetic */ zzadg zzf(zziz zziz2) {
        return zziz2.zzAG;
    }

    static /* synthetic */ zzwv zzg(zziz zziz2) {
        return zziz2.zzAH;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zziz zzAK;

        zza(zziz zziz2) {
            this.zzAK = zziz2;
        }

        @Nullable
        protected abstract T zza(zzkh var1) throws RemoteException;

        @Nullable
        protected abstract T zzdo() throws RemoteException;

        @Nullable
        protected final T zzdp() {
            zzkh zzkh2 = this.zzAK.zzdn();
            if (zzkh2 == null) {
                zzajb.zzaT("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzkh2);
            }
            catch (RemoteException remoteException) {
                zzajb.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzdq() {
            try {
                return this.zzdo();
            }
            catch (RemoteException remoteException) {
                zzajb.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

