/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzzm;
import java.util.concurrent.atomic.AtomicBoolean;

@zzzm
public final class zzlc {
    private final zzup zzBd = new zzup();
    private final zziu zzrS;
    private final AtomicBoolean zzBe;
    private final VideoController zzBf = new VideoController();
    private zzjk zzBg = new zzld(this);
    private zzim zzzN;
    private AdListener zzzO;
    private AdSize[] zzAA;
    private AppEventListener zzsy;
    private Correlator zzBh;
    private zzjz zzBi;
    private OnCustomRenderedAdLoadedListener zzBj;
    private VideoOptions zzst;
    private String zztX;
    private ViewGroup zzBk;
    private int zzBl;
    private boolean zzsw;

    public zzlc(ViewGroup viewGroup) {
        this(viewGroup, null, false, zziu.zzAt, 0);
    }

    public zzlc(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zziu.zzAt, n);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zziu.zzAt, 0);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zziu.zzAt, n);
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, zzjz zzjz2, int n) {
        this.zzBk = viewGroup;
        this.zzrS = zziu2;
        this.zzBi = null;
        this.zzBe = new AtomicBoolean(false);
        this.zzBl = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zziy zziy2 = new zziy(context, attributeSet);
                this.zzAA = zziy2.zzg(bl);
                this.zztX = zziy2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzji.zzds().zza(viewGroup, new zziv(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzBl;
                AdSize adSize = this.zzAA[0];
                Context context2 = context;
                zziv zziv2 = new zziv(context2, adSize);
                new zziv(context2, adSize).zzAz = bl2 = zzlc.zzl(n2);
                zzji.zzds().zza(viewGroup, zziv2, "Ads by Google");
            }
        }
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, int n) {
        this(viewGroup, attributeSet, bl, zziu2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzBi != null) {
                this.zzBi.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzzO;
    }

    public final AdSize getAdSize() {
        try {
            zziv zziv2;
            if (this.zzBi != null && (zziv2 = this.zzBi.zzam()) != null) {
                return zziv2.zzdl();
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzAA != null) {
            return this.zzAA[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzAA;
    }

    public final String getAdUnitId() {
        if (this.zztX == null && this.zzBi != null) {
            try {
                this.zztX = this.zzBi.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzajb.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zztX;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzsy;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzBj;
    }

    public final void zza(zzla zzla2) {
        try {
            if (this.zzBi == null) {
                zzjz zzjz2;
                zziv zziv2;
                zzlc zzlc2 = this;
                if ((zzlc2.zzAA == null || zzlc2.zztX == null) && zzlc2.zzBi == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzlc zzlc3 = zzlc2;
                Context context = zzlc3.zzBk.getContext();
                Object object = zziv2 = zzlc.zza(context, zzlc3.zzAA, zzlc3.zzBl);
                if ("search_v2".equals(object.zzAu)) {
                    String string = zzlc3.zztX;
                    zziv zziv3 = zziv2;
                    Context context2 = context;
                    object = zzji.zzdt();
                    zzjz2 = zziz.zza(context2, false, new zzjb((zziz)object, context2, zziv3, string));
                } else {
                    zzup zzup2 = zzlc3.zzBd;
                    String string = zzlc3.zztX;
                    zziv zziv4 = zziv2;
                    Context context3 = context;
                    object = zzji.zzdt();
                    zzjz2 = zziz.zza(context3, false, new zzja((zziz)object, context3, zziv4, string, zzup2));
                }
                zzlc2.zzBi = zzjz2;
                zzlc2.zzBi.zza(new zzio(zzlc2.zzBg));
                if (zzlc2.zzzN != null) {
                    zzlc2.zzBi.zza(new zzin(zzlc2.zzzN));
                }
                if (zzlc2.zzsy != null) {
                    zzlc2.zzBi.zza(new zzix(zzlc2.zzsy));
                }
                if (zzlc2.zzBj != null) {
                    zzlc2.zzBi.zza(new zznk(zzlc2.zzBj));
                }
                if (zzlc2.zzBh != null) {
                    zzlc2.zzBi.zza(zzlc2.zzBh.zzac());
                }
                if (zzlc2.zzst != null) {
                    zzlc2.zzBi.zza(new zzlx(zzlc2.zzst));
                }
                zzlc2.zzBi.setManualImpressionsEnabled(zzlc2.zzsw);
                zzlc zzlc4 = zzlc2;
                try {
                    IObjectWrapper iObjectWrapper = zzlc4.zzBi.zzal();
                    if (iObjectWrapper != null) {
                        zzlc4.zzBk.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzajb.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzBi.zza(zziu.zza(this.zzBk.getContext(), zzla2))) {
                this.zzBd.zzg(zzla2.zzdz());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzBi != null) {
                this.zzBi.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzBe.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzBi != null) {
                this.zzBi.zzao();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzBi != null) {
                this.zzBi.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzzO = adListener;
        this.zzBg.zza(adListener);
    }

    public final void zza(zzim zzim2) {
        try {
            this.zzzN = zzim2;
            if (this.zzBi != null) {
                this.zzBi.zza(zzim2 != null ? new zzin(zzim2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzAA != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzAA = adSizeArray;
        try {
            if (this.zzBi != null) {
                this.zzBi.zza(zzlc.zza(this.zzBk.getContext(), this.zzAA, this.zzBl));
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzBk.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zztX != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zztX = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsy = appEventListener;
            if (this.zzBi != null) {
                this.zzBi.zza(appEventListener != null ? new zzix(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzBj = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzBi != null) {
                this.zzBi.zza(onCustomRenderedAdLoadedListener != null ? new zznk(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzsw = bl;
        try {
            if (this.zzBi != null) {
                this.zzBi.setManualImpressionsEnabled(this.zzsw);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzBh = correlator;
        try {
            if (this.zzBi != null) {
                this.zzBi.zza(this.zzBh == null ? null : this.zzBh.zzac());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzBi != null) {
                return this.zzBi.zzaI();
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzBi != null) {
                return this.zzBi.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzBf;
    }

    public final zzks zzae() {
        if (this.zzBi == null) {
            return null;
        }
        try {
            return this.zzBi.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzst = videoOptions;
        try {
            if (this.zzBi != null) {
                this.zzBi.zza(videoOptions == null ? null : new zzlx(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzst;
    }

    public final boolean zza(zzjz zzjz2) {
        IObjectWrapper iObjectWrapper;
        if (zzjz2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzjz2.zzal();
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzE((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzBk.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
        this.zzBi = zzjz2;
        return true;
    }

    private static zziv zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zziv zziv2 = new zziv(context, adSizeArray);
        new zziv(context, adSizeArray).zzAz = bl = zzlc.zzl(n);
        return zziv2;
    }

    private static boolean zzl(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzlc zzlc2) {
        return zzlc2.zzBf;
    }
}

