/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzzm;

@zzzm
public final class zzle {
    private final zzup zzBd = new zzup();
    private final Context mContext;
    private final zziu zzrS;
    private AdListener zzzO;
    private zzim zzzN;
    private zzjz zzBi;
    private String zztX;
    private AppEventListener zzsy;
    private PublisherInterstitialAd zzBn;
    private OnCustomRenderedAdLoadedListener zzBj;
    private Correlator zzBh;
    private RewardedVideoAdListener zzcU;
    private boolean zzBo;
    private boolean zzul;

    public zzle(Context context) {
        this(context, zziu.zzAt, null);
    }

    public zzle(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zziu.zzAt, publisherInterstitialAd);
    }

    private zzle(Context context, zziu zziu2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzrS = zziu2;
        this.zzBn = publisherInterstitialAd;
    }

    public final AdListener getAdListener() {
        return this.zzzO;
    }

    public final String getAdUnitId() {
        return this.zztX;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzsy;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzBj;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzBi == null) {
                return false;
            }
            return this.zzBi.isReady();
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzBi == null) {
                return false;
            }
            return this.zzBi.isLoading();
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public final void zza(zzla zzla2) {
        try {
            if (this.zzBi == null) {
                String string = "loadAd";
                zzle zzle2 = this;
                if (zzle2.zztX == null) {
                    zzle2.zzK(string);
                }
                zziv zziv2 = zzle2.zzBo ? zziv.zzdk() : new zziv();
                zzup zzup2 = zzle2.zzBd;
                String string2 = zzle2.zztX;
                zziv zziv3 = zziv2;
                Context context = zzle2.mContext;
                zziz zziz2 = zzji.zzdt();
                zzle2.zzBi = zziz.zza(context, false, new zzjc(zziz2, context, zziv3, string2, zzup2));
                if (zzle2.zzzO != null) {
                    zzle2.zzBi.zza(new zzio(zzle2.zzzO));
                }
                if (zzle2.zzzN != null) {
                    zzle2.zzBi.zza(new zzin(zzle2.zzzN));
                }
                if (zzle2.zzsy != null) {
                    zzle2.zzBi.zza(new zzix(zzle2.zzsy));
                }
                if (zzle2.zzBj != null) {
                    zzle2.zzBi.zza(new zznk(zzle2.zzBj));
                }
                if (zzle2.zzBh != null) {
                    zzle2.zzBi.zza(zzle2.zzBh.zzac());
                }
                if (zzle2.zzcU != null) {
                    zzle2.zzBi.zza(new zzadh(zzle2.zzcU));
                }
                zzle2.zzBi.setImmersiveMode(zzle2.zzul);
            }
            if (this.zzBi.zza(zziu.zza(this.mContext, zzla2))) {
                this.zzBd.zzg(zzla2.zzdz());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzzO = adListener;
            if (this.zzBi != null) {
                this.zzBi.zza(adListener != null ? new zzio(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(zzim zzim2) {
        try {
            this.zzzN = zzim2;
            if (this.zzBi != null) {
                this.zzBi.zza(zzim2 != null ? new zzin(zzim2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zztX != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zztX = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsy = appEventListener;
            if (this.zzBi != null) {
                this.zzBi.zza(appEventListener != null ? new zzix(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzBj = onCustomRenderedAdLoadedListener;
            if (this.zzBi != null) {
                this.zzBi.zza(onCustomRenderedAdLoadedListener != null ? new zznk(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzBh = correlator;
        try {
            if (this.zzBi != null) {
                this.zzBi.zza(this.zzBh == null ? null : this.zzBh.zzac());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzcU = rewardedVideoAdListener;
            if (this.zzBi != null) {
                this.zzBi.zza(rewardedVideoAdListener != null ? new zzadh(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzBo = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzBi != null) {
                return this.zzBi.zzaI();
            }
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzK("show");
            this.zzBi.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to show interstitial.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzul = bl;
            if (this.zzBi != null) {
                this.zzBi.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajb.zzc("Failed to set immersive mode", remoteException);
            return;
        }
    }

    private final void zzK(String string) {
        if (this.zzBi == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

