/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzzn;

@zzzn
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @Nullable
    private zzks zzsd;
    @Nullable
    private VideoLifecycleCallbacks zzse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzks zzks2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzsd = zzks2;
            if (this.zzse != null) {
                this.setVideoLifecycleCallbacks(this.zzse);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzks zzae() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return;
            }
            try {
                this.zzsd.play();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return;
            }
            try {
                this.zzsd.pause();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return;
            }
            try {
                this.zzsd.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return true;
            }
            try {
                return this.zzsd.isMuted();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return 0;
            }
            try {
                return this.zzsd.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return false;
            }
            try {
                return this.zzsd.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        zzbo.zzb((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzse = videoLifecycleCallbacks;
            if (this.zzsd == null) {
                return;
            }
            try {
                this.zzsd.zza(new zzlw(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzsd != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzsd == null) {
                return 0.0f;
            }
            try {
                return this.zzsd.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

