/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzzn;
import java.util.concurrent.atomic.AtomicBoolean;

@zzzn
public final class zzlc {
    private final zzup zzBb = new zzup();
    private final zziu zzrQ;
    private final AtomicBoolean zzBc;
    private final VideoController zzBd = new VideoController();
    private zzjk zzBe = new zzld(this);
    private zzim zzzL;
    private AdListener zzzM;
    private AdSize[] zzAy;
    private AppEventListener zzsw;
    private Correlator zzBf;
    private zzjz zzBg;
    private OnCustomRenderedAdLoadedListener zzBh;
    private VideoOptions zzsr;
    private String zztV;
    private ViewGroup zzBi;
    private int zzBj;
    private boolean zzsu;

    public zzlc(ViewGroup viewGroup) {
        this(viewGroup, null, false, zziu.zzAr, 0);
    }

    public zzlc(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zziu.zzAr, n);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zziu.zzAr, 0);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zziu.zzAr, n);
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, zzjz zzjz2, int n) {
        this.zzBi = viewGroup;
        this.zzrQ = zziu2;
        this.zzBg = null;
        this.zzBc = new AtomicBoolean(false);
        this.zzBj = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zziy zziy2 = new zziy(context, attributeSet);
                this.zzAy = zziy2.zzg(bl);
                this.zztV = zziy2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzji.zzds().zza(viewGroup, new zziv(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzBj;
                AdSize adSize = this.zzAy[0];
                Context context2 = context;
                zziv zziv2 = new zziv(context2, adSize);
                new zziv(context2, adSize).zzAx = bl2 = zzlc.zzl(n2);
                zzji.zzds().zza(viewGroup, zziv2, "Ads by Google");
            }
        }
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, int n) {
        this(viewGroup, attributeSet, bl, zziu2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzBg != null) {
                this.zzBg.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzzM;
    }

    public final AdSize getAdSize() {
        try {
            zziv zziv2;
            if (this.zzBg != null && (zziv2 = this.zzBg.zzam()) != null) {
                return zziv2.zzdl();
            }
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzAy != null) {
            return this.zzAy[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzAy;
    }

    public final String getAdUnitId() {
        if (this.zztV == null && this.zzBg != null) {
            try {
                this.zztV = this.zzBg.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzajc.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zztV;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzsw;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzBh;
    }

    public final void zza(zzla zzla2) {
        try {
            if (this.zzBg == null) {
                zzjz zzjz2;
                zziv zziv2;
                zzlc zzlc2 = this;
                if ((zzlc2.zzAy == null || zzlc2.zztV == null) && zzlc2.zzBg == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzlc zzlc3 = zzlc2;
                Context context = zzlc3.zzBi.getContext();
                Object object = zziv2 = zzlc.zza(context, zzlc3.zzAy, zzlc3.zzBj);
                if ("search_v2".equals(object.zzAs)) {
                    String string = zzlc3.zztV;
                    zziv zziv3 = zziv2;
                    Context context2 = context;
                    object = zzji.zzdt();
                    zzjz2 = zziz.zza(context2, false, new zzjb((zziz)object, context2, zziv3, string));
                } else {
                    zzup zzup2 = zzlc3.zzBb;
                    String string = zzlc3.zztV;
                    zziv zziv4 = zziv2;
                    Context context3 = context;
                    object = zzji.zzdt();
                    zzjz2 = zziz.zza(context3, false, new zzja((zziz)object, context3, zziv4, string, zzup2));
                }
                zzlc2.zzBg = zzjz2;
                zzlc2.zzBg.zza(new zzio(zzlc2.zzBe));
                if (zzlc2.zzzL != null) {
                    zzlc2.zzBg.zza(new zzin(zzlc2.zzzL));
                }
                if (zzlc2.zzsw != null) {
                    zzlc2.zzBg.zza(new zzix(zzlc2.zzsw));
                }
                if (zzlc2.zzBh != null) {
                    zzlc2.zzBg.zza(new zznk(zzlc2.zzBh));
                }
                if (zzlc2.zzBf != null) {
                    zzlc2.zzBg.zza(zzlc2.zzBf.zzac());
                }
                if (zzlc2.zzsr != null) {
                    zzlc2.zzBg.zza(new zzlx(zzlc2.zzsr));
                }
                zzlc2.zzBg.setManualImpressionsEnabled(zzlc2.zzsu);
                zzlc zzlc4 = zzlc2;
                try {
                    IObjectWrapper iObjectWrapper = zzlc4.zzBg.zzal();
                    if (iObjectWrapper != null) {
                        zzlc4.zzBi.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzajc.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzBg.zza(zziu.zza(this.zzBi.getContext(), zzla2))) {
                this.zzBb.zzg(zzla2.zzdz());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzBg != null) {
                this.zzBg.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzBc.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzBg != null) {
                this.zzBg.zzao();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzBg != null) {
                this.zzBg.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzzM = adListener;
        this.zzBe.zza(adListener);
    }

    public final void zza(zzim zzim2) {
        try {
            this.zzzL = zzim2;
            if (this.zzBg != null) {
                this.zzBg.zza(zzim2 != null ? new zzin(zzim2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzAy != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzAy = adSizeArray;
        try {
            if (this.zzBg != null) {
                this.zzBg.zza(zzlc.zza(this.zzBi.getContext(), this.zzAy, this.zzBj));
            }
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzBi.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zztV != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zztV = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsw = appEventListener;
            if (this.zzBg != null) {
                this.zzBg.zza(appEventListener != null ? new zzix(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzBh = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzBg != null) {
                this.zzBg.zza(onCustomRenderedAdLoadedListener != null ? new zznk(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzsu = bl;
        try {
            if (this.zzBg != null) {
                this.zzBg.setManualImpressionsEnabled(this.zzsu);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzBf = correlator;
        try {
            if (this.zzBg != null) {
                this.zzBg.zza(this.zzBf == null ? null : this.zzBf.zzac());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzBg != null) {
                return this.zzBg.zzaI();
            }
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzBg != null) {
                return this.zzBg.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzBd;
    }

    public final zzks zzae() {
        if (this.zzBg == null) {
            return null;
        }
        try {
            return this.zzBg.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzsr = videoOptions;
        try {
            if (this.zzBg != null) {
                this.zzBg.zza(videoOptions == null ? null : new zzlx(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzsr;
    }

    public final boolean zza(zzjz zzjz2) {
        IObjectWrapper iObjectWrapper;
        if (zzjz2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzjz2.zzal();
        }
        catch (RemoteException remoteException) {
            zzajc.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzE((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzBi.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
        this.zzBg = zzjz2;
        return true;
    }

    private static zziv zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zziv zziv2 = new zziv(context, adSizeArray);
        new zziv(context, adSizeArray).zzAx = bl = zzlc.zzl(n);
        return zziv2;
    }

    private static boolean zzl(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzlc zzlc2) {
        return zzlc2.zzBd;
    }
}

