/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzzn;
import java.util.Date;
import java.util.Set;

@zzzn
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzalj {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzcM;
    private InterstitialAd zzcN;
    private AdLoader zzcO;
    private Context zzcP;
    private InterstitialAd zzcQ;
    private MediationRewardedVideoAdListener zzcR;
    private RewardedVideoAdListener zzcS = new com.google.ads.mediation.zza(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzji.zzds();
            builder.addTestDevice(zzaiy.zzV(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzcM != null) {
            this.zzcM.destroy();
            this.zzcM = null;
        }
        if (this.zzcN != null) {
            this.zzcN = null;
        }
        if (this.zzcO != null) {
            this.zzcO = null;
        }
        if (this.zzcQ != null) {
            this.zzcQ = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzcM != null) {
            this.zzcM.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzcM != null) {
            this.zzcM.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcM = new AdView(context);
        this.zzcM.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzcM.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcM.setAdListener(new zzc(this, mediationBannerListener));
        this.zzcM.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzcM;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcN = new InterstitialAd(context);
        this.zzcN.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcN.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzcN.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzcN != null) {
            this.zzcN.setImmersiveMode(bl);
        }
        if (this.zzcQ != null) {
            this.zzcQ.setImmersiveMode(bl);
        }
    }

    @Override
    public zzks getVideoController() {
        VideoController videoController;
        if (this.zzcM != null && (videoController = this.zzcM.getVideoController()) != null) {
            return videoController.zzae();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzcN.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzB(1).zzjh();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzfz()) {
            for (String string2 : nativeMediationAdRequest.zzfA().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzfA().get(string2) != false ? zze2 : null);
            }
        }
        this.zzcO = builder.build();
        this.zzcO.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzcP = context.getApplicationContext();
        this.zzcR = mediationRewardedVideoAdListener;
        this.zzcR.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzcP == null || this.zzcR == null) {
            zzajc.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzcQ = new InterstitialAd(this.zzcP);
        this.zzcQ.zza(true);
        this.zzcQ.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcQ.setRewardedVideoAdListener(this.zzcS);
        this.zzcQ.loadAd(this.zza(this.zzcP, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzcQ.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzcR != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzcR;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzcQ = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzcV;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzcV = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcV);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzcU;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcU = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcU);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener {
        private AbstractAdViewAdapter zzcW;
        private MediationNativeListener zzcZ;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzcW = abstractAdViewAdapter;
            this.zzcZ = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzcZ.onAdFailedToLoad(this.zzcW, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzcZ.onAdOpened(this.zzcW);
        }

        @Override
        public final void onAdClosed() {
            this.zzcZ.onAdClosed(this.zzcW);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzcZ.onAdLeftApplication(this.zzcW);
        }

        @Override
        public final void onAdClicked() {
            this.zzcZ.onAdClicked(this.zzcW);
        }

        @Override
        public final void onAdImpression() {
            this.zzcZ.onAdImpression(this.zzcW);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcZ.onAdLoaded(this.zzcW, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzcZ.onAdLoaded(this.zzcW, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzcZ.zza(this.zzcW, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzcZ.zza(this.zzcW, nativeCustomTemplateAd, string);
        }
    }

    static final class zzd
    extends AdListener
    implements zzim {
        private AbstractAdViewAdapter zzcW;
        private MediationInterstitialListener zzcY;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzcW = abstractAdViewAdapter;
            this.zzcY = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzcY.onAdLoaded(this.zzcW);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzcY.onAdFailedToLoad(this.zzcW, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzcY.onAdOpened(this.zzcW);
        }

        @Override
        public final void onAdClosed() {
            this.zzcY.onAdClosed(this.zzcW);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzcY.onAdLeftApplication(this.zzcW);
        }

        @Override
        public final void onAdClicked() {
            this.zzcY.onAdClicked(this.zzcW);
        }
    }

    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzim {
        private AbstractAdViewAdapter zzcW;
        private MediationBannerListener zzcX;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzcW = abstractAdViewAdapter;
            this.zzcX = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzcX.onAdLoaded(this.zzcW);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzcX.onAdFailedToLoad(this.zzcW, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzcX.onAdOpened(this.zzcW);
        }

        @Override
        public final void onAdClosed() {
            this.zzcX.onAdClosed(this.zzcW);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzcX.onAdLeftApplication(this.zzcW);
        }

        @Override
        public final void onAdClicked() {
            this.zzcX.onAdClicked(this.zzcW);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzcX.zza(this.zzcW, string, string2);
        }
    }
}

