/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzmc;
import com.google.android.gms.internal.zzzt;

@zzzt
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @Nullable
    private zzky zzalc;
    @Nullable
    private VideoLifecycleCallbacks zzald;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzky zzky2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzalc = zzky2;
            if (this.zzald != null) {
                this.setVideoLifecycleCallbacks(this.zzald);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzky zzbc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzalc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return;
            }
            try {
                this.zzalc.play();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return;
            }
            try {
                this.zzalc.pause();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return;
            }
            try {
                this.zzalc.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return true;
            }
            try {
                return this.zzalc.isMuted();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return 0;
            }
            try {
                return this.zzalc.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return false;
            }
            try {
                return this.zzalc.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        zzbp.zzb((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzald = videoLifecycleCallbacks;
            if (this.zzalc == null) {
                return;
            }
            try {
                this.zzalc.zza(new zzmc(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzald;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzalc != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzalc == null) {
                return 0.0f;
            }
            try {
                return this.zzalc.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzaji.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public VideoLifecycleCallbacks() {
        }

        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

