/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlh;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzlg zzaks;

    private PublisherAdRequest(Builder builder) {
        this.zzaks = new zzlg(builder.zzakt);
    }

    public final Date getBirthday() {
        return this.zzaks.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzaks.getContentUrl();
    }

    public final int getGender() {
        return this.zzaks.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzaks.getKeywords();
    }

    public final Location getLocation() {
        return this.zzaks.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzaks.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaks.getNetworkExtras(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaks.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaks.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzaks.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzaks.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzaks.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    public final zzlg zzaz() {
        return this.zzaks;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    public static final class Builder {
        private final zzlh zzakt = new zzlh();

        public Builder() {
        }

        public final Builder addKeyword(String string) {
            this.zzakt.zzac(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzakt.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzakt.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzakt.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzakt.zzad(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zzakt.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            zzbp.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzbp.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzbp.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzakt.zzaf(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zzakt.zzp(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzakt.zzb(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzakt.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzakt.zzag(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzakt.zzah(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzakt.zzi(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzakt.zzf(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzakt.zzf(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzakt.zzai(string);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzakt.zzj(bl);
            return this;
        }
    }
}

