/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.internal.zzadn;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzpg;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzva;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxg;
import com.google.android.gms.internal.zzzt;

@zzzt
public class zzjf {
    private zzkn zzbcx;
    private final Object mLock = new Object();
    private final zziw zzbcy;
    private final zziv zzbcz;
    private final zzlo zzbda;
    private final zzqm zzbdb;
    private final zzadn zzbdc;
    private final zzxf zzbdd;

    public zzjf(zziw zziw2, zziv zziv2, zzlo zzlo2, zzqm zzqm2, zzadn zzadn2, zzxf zzxf2) {
        this.zzbcy = zziw2;
        this.zzbcz = zziv2;
        this.zzbda = zzlo2;
        this.zzbdb = zzqm2;
        this.zzbdc = zzadn2;
        this.zzbdd = zzxf2;
    }

    @Nullable
    private static zzkn zzho() {
        try {
            Object obj = zzjf.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzaji.zzcs("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzko.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzaji.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzkn zzhp() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbcx == null) {
                this.zzbcx = zzjf.zzho();
            }
            return this.zzbcx;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl) {
            zzjo.zzhu();
            if (!zzaje.zzba(context)) {
                zzaji.zzcb("Google Play Services is not available");
                bl = true;
            }
        }
        zzjo.zzhu();
        int n = zzaje.zzat(context);
        zzjo.zzhu();
        if (n > zzaje.zzas(context)) {
            bl = true;
        }
        if (bl) {
            t = zza2.zzhr();
            if (t == null) {
                t = zza2.zzhs();
            }
        } else {
            t = zza2.zzhs();
            if (t == null) {
                t = zza2.zzhr();
            }
        }
        return t;
    }

    private static void zzb(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzjo.zzhu().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzka zzb(Context context, String string, zzva zzva2) {
        return zzjf.zza(context, false, new zzjj(this, context, string, zzva2));
    }

    public final zzpg zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        return zzjf.zza(context, false, new zzjl(this, frameLayout, frameLayout2, context));
    }

    @Nullable
    public final zzxg zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzaji.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        boolean bl2 = bl;
        return zzjf.zza((Context)activity, bl2, new zzjn(this, activity));
    }

    static /* synthetic */ zziw zzb(zzjf zzjf2) {
        return zzjf2.zzbcy;
    }

    static /* synthetic */ void zza(zzjf zzjf2, Context context, String string) {
        zzjf.zzb(context, string);
    }

    static /* synthetic */ zziv zzc(zzjf zzjf2) {
        return zzjf2.zzbcz;
    }

    static /* synthetic */ zzlo zzd(zzjf zzjf2) {
        return zzjf2.zzbda;
    }

    static /* synthetic */ zzqm zze(zzjf zzjf2) {
        return zzjf2.zzbdb;
    }

    static /* synthetic */ zzadn zzf(zzjf zzjf2) {
        return zzjf2.zzbdc;
    }

    static /* synthetic */ zzxf zzg(zzjf zzjf2) {
        return zzjf2.zzbdd;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zzjf zzbdg;

        zza(zzjf zzjf2) {
            this.zzbdg = zzjf2;
        }

        @Nullable
        protected abstract T zza(zzkn var1) throws RemoteException;

        @Nullable
        protected abstract T zzhq() throws RemoteException;

        @Nullable
        protected final T zzhr() {
            zzkn zzkn2 = this.zzbdg.zzhp();
            if (zzkn2 == null) {
                zzaji.zzcs("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzkn2);
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzhs() {
            try {
                return this.zzhq();
            }
            catch (RemoteException remoteException) {
                zzaji.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

